﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Maps;
using BMS.VistaIntegration.Data;

namespace Mdws2ORM.Maps.WF
{
    public class AdmittedPatientMap : EntityMap<AdmittedPatient>
    {
        public override string File
        {
            get { return "2"; }
        }

        public override string Location
        {
            get { return "DPT("; }
        }

        protected override void MapFields()
        {
            MapFreeText(".01", (e, value) => e.Name = value);
            MapFreeText(".09", (e, value) => e.SSN = GetSsn(value));
            MapPointerToFile(".101", (e, value) => e.BedName = value);
            MapPointerToFile(".102", (e, value) => e.MovementIen = value);
            MapPointerToFile(".105", (e, value) => e.AdmissionIen = value);
            MapPointerToFile(".1", (e, value) => e.WardName = value);
        }

        private static string GetSsn(string value)
        {
            try
            {
                return value.Insert(3, "-").Insert(6, "-");
            }
            catch
            {
                return value;
            }
        }

        public override AdmittedPatient NewEntity(string ien)
        {
            return new AdmittedPatient() { IEN = ien };
        }
    }
}
