﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;

namespace Mdws2ORM.Maps.EIS
{
    public class WardLocationMap : EntityMap<WardLocation>
    {
        public override WardLocation NewEntity(string ien)
        {
            return new WardLocation() { IEN = ien };
        }


        public override string File
        {
            get { return "42"; }
        }

        public override string Location
        {
            get { return "DIC(42,"; }
        }

        protected override void MapFields()
        {
            MapFreeText(".01", (m, s) => m.Name = s);
            MapPointerToFile<Specialty>(".017", (m, s) => m.SpecialtyId = s, (m, s) => m.Specialty = s);
            MapBoolean(".2", (m, s) => m.IsCurrentlyOutOfService = s); 
        }
    }
}
