﻿using System;
using System.Linq;
using System.Text;
using System.Collections.Generic;
using Mdws2ORM;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws.Commands.EntityCommands;
using BMS.VistaIntegration.Mdws.Commands.Concrete;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws.Commands.Concrete.WF
{
    public class ListPatientMovementsByAdmissionCommand
    {
        public string AdmissionIen { get; set; }
        public int? MaxCount { get; set; }
        private const string ScreenFormat = "I $P(^DGPM(Y,0),U,14)={0}";

        private string GetScreen()
        {
            return string.Format(ScreenFormat, AdmissionIen);                
        }

        public List<PatientMovement> Execute(ISession session)
        {
            long admIen;
            List<PatientMovement> result = new List<PatientMovement>();
            if (string.IsNullOrEmpty(AdmissionIen))
            {
                Tracer.TraceMessage("ListPatientMovementsByAdmissionCommand - Admission Ien was not provided!");
                return result;
            }            

            ListParamBuilder builder = new ListParamBuilder();
            builder.Index("CA");
            builder.Screen(GetScreen());
            if (MaxCount.HasValue)
                builder.Number(MaxCount.Value.ToString());

            string from = null;
            bool correctIen = long.TryParse(AdmissionIen, out admIen);
            if (correctIen)
                from = (admIen - 1).ToString();
            else
                from = AdmissionIen;
            builder.From(from);
            builder.Partial(AdmissionIen);
            bool hasMore = true;
            int size = 0;
            if (MaxCount.HasValue)
                size = MaxCount.Value;
            while (hasMore)
            {                
                result = session.List<PatientMovement>(builder.Build()).Select(s => s.Entity).ToList();             
                hasMore = MaxCount.HasValue ? size == result.Count : false;
                if (hasMore)
                {
                    size = size * 2;
                    builder.Number((size).ToString());
                }
            }
            if (!correctIen)
                result.Add(session.Get<PatientMovement>(GetParamBuilder.DefaultParam, AdmissionIen + ","));
            return result;
        }
    }
}
