﻿using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using Mdws2ORM.Maps;
using Mdws2ORM.QuerySvcService;
using BMS.VistaIntegration.Mdws.Commands.EntityCommands;
using BMS.VistaIntegration.Data.WF;
using System;
using Mdws2ORM;
using BMS.VistaIntegration.Mdws.Commands.Concrete;
using BMS.Utils;

namespace BMS.VistaIntegration.Mdws.Commands.WF
{
    class ListBedSwitchCommand
    {

        public IEnumerable<string> PatientMovementsIEn { get; set; }

        public List<BedSwitch> Execute(ISession session)
        {

            List<BedSwitch> result = new List<BedSwitch>(PatientMovementsIEn.Count());
             
            foreach (string ien in PatientMovementsIEn)
            {
                BedSwitch bedSwitch = session.Get<BedSwitch>(GetParamBuilder.DefaultParam, ien + ",");
                if (bedSwitch == null)
                {
                    BmsLogger logger = new BmsLogger("ListBedSwitchCommand");
                    logger.LogFormat(BmsLogger.Level.Warning, "Patient Movement with ien {0} was not found", ien);
                }
                else
                {
                    result.Add(bedSwitch);
                }
            }

            return result;
        }

    }
}
