﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM;

namespace BMS.VistaIntegration.Mdws.Commands.Concrete
{
    public struct ScreenPart
    {
        public ScreenPart(string screen, string minIen, int count)
        {
            Screen = screen;
            MinIen = minIen;
            Count = count;
        }

        public readonly string Screen;
        public readonly string MinIen;
        public readonly int Count;
    }

    public static class ParamUtilities
    {
        public const int MAX_SIZE = 400;

        public static IEnumerable<ScreenPart> GetScreens(IEnumerable<string> iens, string init = "", string variable = "Y", bool isString = false)
        {
            string format = isString ?
                "({0}=\"{1}\")!" :
                "({0}={1})!";
            init += "I ";
            if (!iens.Any())
                throw new ArgumentException();

            StringBuilder sb = new StringBuilder(init);
            int count = 0;
            string minIen = iens.First();

            foreach (string ien in iens)
            {
                string s = string.Format(format, variable, ien);
                if (sb.Length + s.Length >= MAX_SIZE)
                {
                    sb.Remove(sb.Length - 1, 1);
                    yield return new ScreenPart(sb.ToString(), minIen, count);
                    count = 0;
                    minIen = ien;
                    sb = new StringBuilder(init);
                }
                count++;
                sb.Append(s);
            }

            sb.Remove(sb.Length - 1, 1);
            yield return new ScreenPart(sb.ToString(), minIen, count);

        }

        public static IEnumerable<string> GetPartMonthBetweenDates(DateTime startTime, DateTime endTime)
        {
            DateTime time = new DateTime(startTime.Year, startTime.Month, 1);
            while (time <= endTime)
            {
                yield return GetMonthPart(time);
                time = time.AddMonths(1);
            }
        }

        public static string GetMonthPart(DateTime time)
        {
            return Converters.ToInternalFormat(time).Substring(0, 5);
        }





    }
}
