﻿using System;
using System.Security.Cryptography;
using System.Text;
using System.IO;

namespace BMS.Utils
{
    /// <summary>
    /// Encryption/decryption utility class.
    /// </summary>
    public class Encryptor
    {
        //const string encryption_password = ".theP@assword.";
        const string encryption_saltBytes = ".saltIsGoodForYou.";

        /// <summary>
        /// Encryption method.
        /// </summary>
        /// <param name="input">string to encrypt</param>
        /// <returns>encrypted string</returns>
        public static string Encrypt(string input, string encryptionPassword)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string data = input;
                byte[] utfdata = UTF8Encoding.UTF8.GetBytes(data);
                byte[] saltBytes = UTF8Encoding.UTF8.GetBytes(encryption_saltBytes);

                // symmetric encryption algorithm
                using (AesManaged aes = new AesManaged())
                {
                    // Setting parameters
                    aes.BlockSize = aes.LegalBlockSizes[0].MaxSize;
                    aes.KeySize = aes.LegalKeySizes[0].MaxSize;

                    // We're using the PBKDF2 standard for password-based key generation
                    using (Rfc2898DeriveBytes rfc = new Rfc2898DeriveBytes(encryptionPassword, saltBytes))
                    {
                        aes.Key = rfc.GetBytes(aes.KeySize / 8);
                        aes.IV = rfc.GetBytes(aes.BlockSize / 8);
                    }

                    // Encryption
                    ICryptoTransform encryptTransf = aes.CreateEncryptor();

                    using (MemoryStream encryptStream = new MemoryStream())
                    {
                        CryptoStream encryptor = new CryptoStream(encryptStream, encryptTransf, CryptoStreamMode.Write);

                        encryptor.Write(utfdata, 0, utfdata.Length);
                        encryptor.Flush();
                        encryptor.FlushFinalBlock(); //      encryptor.Close();

                        byte[] encryptBytes = encryptStream.ToArray();
                        //string encryptedString = Encoding.BigEndianUnicode.GetString(encryptBytes, 0, encryptBytes.Length);            
                        string encryptedString = ConvertToAlphabetString(encryptBytes);

                        return encryptedString;
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        /// <summary>
        /// Decryption method.
        /// </summary>
        /// <param name="input">String to decrypt.</param>
        /// <returns>Decrypted string.</returns>
        public static string Decrypt(string input, string encryptionPassword)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                //byte[] encryptBytes = Encoding.BigEndianUnicode.GetBytes(input);
                byte[] encryptBytes = ConvertFromAlphabetString(input);
                byte[] saltBytes = Encoding.UTF8.GetBytes(encryption_saltBytes);

                // symmetric encryption algorithm
                using (AesManaged aes = new AesManaged())
                {
                    // Setting our parameters
                    aes.BlockSize = aes.LegalBlockSizes[0].MaxSize;
                    aes.KeySize = aes.LegalKeySizes[0].MaxSize;

                    // We're using the PBKDF2 standard for password-based key generation
                    using (Rfc2898DeriveBytes rfc = new Rfc2898DeriveBytes(encryptionPassword, saltBytes))
                    {
                        aes.Key = rfc.GetBytes(aes.KeySize / 8);
                        aes.IV = rfc.GetBytes(aes.BlockSize / 8);
                    }

                    // Now, decryption
                    ICryptoTransform decryptTrans = aes.CreateDecryptor();

                    // Output stream, can be also a FileStream
                    using (MemoryStream decryptStream = new MemoryStream())
                    {
                        CryptoStream decryptor = new CryptoStream(decryptStream, decryptTrans, CryptoStreamMode.Write);

                        decryptor.Write(encryptBytes, 0, encryptBytes.Length);
                        decryptor.Flush();
                        decryptor.FlushFinalBlock(); //decryptor.Close();

                        // Showing our decrypted content
                        byte[] decryptBytes = decryptStream.ToArray();
                        string decryptedString = UTF8Encoding.UTF8.GetString(decryptBytes, 0, decryptBytes.Length);

                        return decryptedString;
                    }
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        //const int size = 52;  //  dead code per fortify
        public static string ConvertToAlphabetString(byte[] input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (input == null || input.Length == 0)
                    return String.Empty;
                StringBuilder sb = new StringBuilder();
                System.Collections.IEnumerator ien = input.GetEnumerator();
                byte c1, c2;

                while (ien.MoveNext())
                {
                    byte b = (byte)ien.Current;
                    c1 = (byte)(b / 52);
                    c2 = (byte)(b % 52);
                    c1 = (byte)(c1 + 65);
                    c2 = (byte)(c2 <= 25 ? c2 + 65 : c2 + 71);

                    sb.Append((char)c1);
                    sb.Append((char)c2);
                }
                return sb.ToString();
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        
        public static byte[] ConvertFromAlphabetString(string input)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (String.IsNullOrEmpty(input))
                    return null;
                byte[] rez = new byte[input.Length / 2];
                System.Collections.IEnumerator ien = input.ToCharArray().GetEnumerator();
                int i = 0;
                while (ien.MoveNext())
                {
                    char c1 = (char)ien.Current;
                    ien.MoveNext();
                    char c2 = (char)ien.Current;
                    c1 = (char)(c1 - 65);
                    c2 = (char)(c2 <= 90 ? c2 - 65 : c2 - 71);

                    rez[i++] = (byte)(c1 * 52 + c2);

                }
                return rez;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
