﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.Proxy;
using BMS.Utils;

namespace BMS.ServicesWrapper.EVS
{
    /// <summary>
    /// EVS factory class responsible for EVS wrapper creation and proxy accessing.
    /// </summary>
    public class EVSFactory
    {
        /// <summary>
        /// The underlying IEVSWrapper instance as readonly.
        /// </summary>
        private static readonly IEVSWrapper _instance = new EVSWrapper(false);

        /// <summary>
        /// The underlying IEVSWrapper Windows instance as readonly.
        /// </summary>
        private static readonly IEVSWrapper _instanceWindows = new EVSWrapper(true);

        /// <summary>
        /// The EVSWrapper instance used by clients.
        /// </summary>
        public static IEVSWrapper Instance
        {
            get { return EVSFactory._instance; }
        }

        /// <summary>
        /// The EVSWrapper Windows instance used by clients.
        /// </summary>
        public static IEVSWrapper InstanceWindows
        {
            get { return EVSFactory._instanceWindows; }
        }

        /// <summary>
        /// The client instance used by calls from WCF/WF that use the DurableIssuedTokenClientCredentials
        /// if there is a current SessionID or the windows instance otherwise.
        /// </summary>
        public static IEVSWrapper InstanceFromWCF
        {
            get
            {
                if (!String.IsNullOrEmpty(ProxyManager.GetCurrentSessionID()))
                    return Instance;
                else
                    return InstanceWindows;
            }
        }

        /// <summary>
        /// Private instance used to access the internal methods.
        /// </summary>
// dead code per fortify
/*
        private static EVSWrapper EVSWrapperInstance
        {
            get { return _instance as EVSWrapper; }
        }
*/
        /// <summary>
        /// Private Windows instance used to access the internal methods.
        /// </summary>
        private static EVSWrapper EVSWrapperInstanceWindows
        {
            get { return _instanceWindows as EVSWrapper; }
        }

        /// <summary>
        /// The static constructors loads all supported EVS CodeSystems that are needed to create the return
        /// CD list with the code, codeSystem, codeSystenName and displayName properties.
        /// </summary>                
        static EVSFactory()
        {
            EVSWrapperInstanceWindows.InitSupportedCodeSystems();
        }

        /// <summary>
        /// Access to the EVS MessageBrowser WCF proxy.
        /// </summary>
        internal static BMS.ServicesWrapper.Proxy.EVS.MAPI.BrowserOperationsClient CTSMessageBrowse
        {
            get { return ProxyManager.GetProxy<BMS.ServicesWrapper.Proxy.EVS.MAPI.BrowserOperationsClient>("EVS.CTSMessageBrowse"); }
        }

        /// <summary>
        /// Access to the EVS MessageBrowser WCF proxy using Windows authentication.
        /// </summary>
        internal static BMS.ServicesWrapper.Proxy.EVS.MAPI.BrowserOperationsClient CTSMessageBrowseWindows
        {
            get { return ProxyManager.GetProxy<BMS.ServicesWrapper.Proxy.EVS.MAPI.BrowserOperationsClient>("EVS.CTSMessageBrowse"); }
        }

        /// <summary>
        /// Access to the EVS VocabularyRuntime WCF proxy.
        /// </summary>
        internal static BMS.ServicesWrapper.Proxy.EVS.VAPI.RuntimeOperationsClient CTSVocabularyRuntime
        {
            get { return ProxyManager.GetProxy<BMS.ServicesWrapper.Proxy.EVS.VAPI.RuntimeOperationsClient>("EVS.CTSVocabularyRuntime"); }
        }

        /// <summary>
        /// Access to the EVS VocabularyRuntime WCF proxy using Windows authentication.
        /// </summary>
        internal static BMS.ServicesWrapper.Proxy.EVS.VAPI.RuntimeOperationsClient CTSVocabularyRuntimeWindows
        {
            get { return ProxyManager.GetProxy<BMS.ServicesWrapper.Proxy.EVS.VAPI.RuntimeOperationsClient>("EVS.CTSVocabularyRuntime"); }
        }

        /// <summary>
        /// Access to the EVS MessageRuntime WCF proxy.
        /// </summary>
        internal static BMS.ServicesWrapper.Proxy.EVS.MAPI.RuntimeOperationsClient CTSMessageRuntime
        {
            get { return ProxyManager.GetProxy<BMS.ServicesWrapper.Proxy.EVS.MAPI.RuntimeOperationsClient>("EVS.CTSMessageRuntime"); }
        }

        /// <summary>
        /// Access to the EVS MessageRuntime WCF proxy using Windows authentication.
        /// </summary>
        internal static BMS.ServicesWrapper.Proxy.EVS.MAPI.RuntimeOperationsClient CTSMessageRuntimeWindows
        {
            get { return ProxyManager.GetProxy<BMS.ServicesWrapper.Proxy.EVS.MAPI.RuntimeOperationsClient>("EVS.CTSMessageRuntime"); }
        }

        /// <summary>
        /// Access to the EVS CTSEditVocabulary WCF proxy.
        /// </summary>
        internal static BMS.ServicesWrapper.Proxy.EVS.Edit.CTSEditVocabularyClient CTSEditVocabulary
        {
            get { return ProxyManager.GetProxy<BMS.ServicesWrapper.Proxy.EVS.Edit.CTSEditVocabularyClient>("EVS.CTSVocabularyEdit"); }
        }

        /// <summary>
        /// Access to the EVS CTSEditVocabulary WCF proxy using Windows authentication.
        /// </summary>
        internal static BMS.ServicesWrapper.Proxy.EVS.Edit.CTSEditVocabularyClient CTSEditVocabularyWindows
        {
            get { return ProxyManager.GetProxy<BMS.ServicesWrapper.Proxy.EVS.Edit.CTSEditVocabularyClient>("EVS.CTSVocabularyEdit"); }
        }

        /// <summary>
        /// Access to the EVS MessageEdit WCF proxy.
        /// </summary>
        internal static BMS.ServicesWrapper.Proxy.EVS.Edit.MessageEditClient MessageEdit
        {
            get { return ProxyManager.GetProxy<BMS.ServicesWrapper.Proxy.EVS.Edit.MessageEditClient>("EVS.CTSMessageEdit"); }
        }

        /// <summary>
        /// Access to the EVS MessageEdit WCF proxy using Windows authentication.
        /// </summary>
        internal static BMS.ServicesWrapper.Proxy.EVS.Edit.MessageEditClient MessageEditWindows
        {
            get { return ProxyManager.GetProxy<BMS.ServicesWrapper.Proxy.EVS.Edit.MessageEditClient>("EVS.CTSMessageEdit"); }
        }

        /// <summary>
        /// Access to the EVS Vocabulary Broswer WCF proxy.
        /// </summary>
        internal static BMS.ServicesWrapper.Proxy.EVS.VAPI.BrowserOperationsClient CTSVocabularyBrowse
        {
            get { return ProxyManager.GetProxy<BMS.ServicesWrapper.Proxy.EVS.VAPI.BrowserOperationsClient>("EVS.CTSVocabularyBrowse"); }
        }

        /// <summary>
        /// Access to the EVS Vocabulary Broswer WCF proxy using Windows authentication.
        /// </summary>
        internal static BMS.ServicesWrapper.Proxy.EVS.VAPI.BrowserOperationsClient CTSVocabularyBrowseWindows
        {
            get { return ProxyManager.GetProxy<BMS.ServicesWrapper.Proxy.EVS.VAPI.BrowserOperationsClient>("EVS.CTSVocabularyBrowse"); }
        }
    }
}
