﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using FC = BMS.Facade.Data;
using BMS.ServicesWrapper.EIS;
using BMS.Utils;
using BMS.Facade.Data;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.Security;
using BMS.VistaWorker2.Writer.Implementation.Concrete;

namespace BMS.VistaWorker2.Writer.Implementation
{
    /// <summary>
    /// The base writer manager implementation.
    /// </summary>
    public class WriterManager : IWriterManager
    {
        public VistASite Site { get; private set; }
        private BmsLogger logger;
        public Concrete.WF.Utils UtilsInstance { get; private set; }

        private CommonData data;

        private void InitLogger()
        {
            string appendInfo = string.Format("VISTA {0} WRITER MESSAGE: ", Site.Name);
            logger = new BmsLogger(appendInfo);
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="BaseWriterManager"/> class.
        /// </summary>
        /// <param name="site">The site.</param>
        internal WriterManager()
        {
        }

        private static Dictionary<Type, object> _entityWriters = new Dictionary<Type, object>();
        private bool isOpen = false;
        private bool isInit = false;

        private void Init()
        {
            if (!isOpen)
                throw new InvalidOperationException();

            if (isInit) return;
            data = new CommonData(this, logger);
            isInit = true;
        }


        /// <summary>
        /// Adds an entity writer to the internal dictionary.
        /// </summary>
        /// <typeparam name="T">Entity type.</typeparam>
        /// <param name="entityWriter">Specilized entity writer for the entity type.</param>
        public static void Add<T, V>()
            where T : BaseEntityWriter<V>, new()
        {
            Func<BaseEntityWriter<V>> func = () =>
                {
                    BaseEntityWriter<V> entityWriter = new T();
                    return entityWriter;
                };
            _entityWriters[typeof(V)] = func;
        }


// dead code per fortify
//        private IEISWrapper EIS { get { return EISFactory.InstanceWindows; } }





        /// <summary>
        /// Opens the writer.
        /// </summary>
        public void Open(VistASite site)
        {

            if (isOpen)
                throw new InvalidOperationException("Already open");

            Site = site;
            isOpen = true;
            isInit = false;
            UtilsInstance = new Concrete.WF.Utils();
            InitLogger();
            logger.LogVerbose("OPEN WRITER");

        }

        /// <summary>
        /// Closes the writer.
        /// </summary>
        public void Close()
        {

            if (!isOpen)
                return;

            data = null;
            isOpen = false;
            isInit = false;
            logger.LogVerbose("CLOSE WRITER");

        }

        public IEntityWriter<T> MakeEntityWriter<T>(bool initCache )
        {
            Init();
            Func<BaseEntityWriter<T>> func = null;
            func = _entityWriters[typeof(T)] as Func<BaseEntityWriter<T>>;
            if (func != null)
            {
                BaseEntityWriter<T> entityWriter = func();
                entityWriter.InitData(data, UtilsInstance);

                if (initCache == true)
                    entityWriter.InitCache();
                return entityWriter;
            }
            else
            {
                return null;
            }
        }




        public IEntityWriter<T> MakeEntityWriter<T>()
        {
            return MakeEntityWriter<T>(true);
        }
    }
}
