﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data.WaitingList;
using BMS.ServicesWrapper.WF;
using BMS.Utils;
using FC = BMS.Facade.Data;
using BMS.VistaIntegration.Data;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.EVS;
using BMS.ServicesWrapper.Security;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.WaitingList
{
    class WaitingListItemWriter : BaseWorkFlowWriter<WaitingListItem>
    {
        private FC.Facility GetFacility(ScheduledAdmission wfScheduledAdmission, FC.Ward ward, CD vistaMedicalDivision)
        {
            List<FC.Facility> facilitiesByVista = null;
            if (vistaMedicalDivision != null && !string.IsNullOrEmpty(vistaMedicalDivision.code))
            {
                facilitiesByVista = EIS.GetFacilities(VistaSite.Id).ToList();
                FC.FacilitySettings settings = null;
                foreach (FC.Facility f in facilitiesByVista)
                {
                    settings = Facade.FacadeManager.ConfigurationInterface.GetFacilitySettings(f.Id);
                    if (settings != null && !string.IsNullOrEmpty(settings.MedicalCenterID) && settings.MedicalCenterID.Equals(vistaMedicalDivision.code, StringComparison.InvariantCultureIgnoreCase))
                        return f;
                }
            }
            if (ward != null)
            {
                IList<FC.Facility> facilities = EIS.GetFacilityIdsForWard(ward.Id);
                if (facilities != null)
                    return facilities.FirstOrDefault();
            }
            return EIS.GetFacilities(VistaSite.Id).FirstOrDefault();
        }

        protected override bool SendEvent(WaitingListItem entity)
        {
            ScheduledAdmission wfScheduledAdmission = entity.ScheduledAdmission;
            FC.Ward ward = InsertIfNullOrUpdateIfDirty<WardLocation, FC.Ward>(wfScheduledAdmission.Ward);
            CD treatingSpecialty = InsertIfNullOrUpdateIfDirty<FacilityTreatingSpecialty, CD>(wfScheduledAdmission.TreatingSpecialty);
            CD medicalCenterDivision = InsertIfNullOrUpdateIfDirty<MedicalCenterDivision, CD>(wfScheduledAdmission.MedicalCenterDivision);

            FC.WaitingListItem item = new FC.WaitingListItem();
            IList<CD> cds = EVS.GetCodes(new CodeFilterParameters() { VocabularyDomain = BMS.Facade.Data.Util.Vocabulary.WaitingArea.ToString(), MaxSelectedCodes = int.MaxValue });
            item.WaitingArea = cds.FirstOrDefault(cd => cd.code == Constants.WAITING_AREA_SCHEDULED_ADMISSIONS);
            string domain = SecurityFactory.InstanceWindows.GetCurrentDomain();
            item.Id = new II(domain, null);
            item.Patient = MakeWfPatient(wfScheduledAdmission.Patient);
            //INC000001003458 - Replacing ReservationDateTime with null. 
            item.RequestedBedDate = null;

            item.Facility = GetFacility(wfScheduledAdmission, ward, medicalCenterDivision);
            item.Problem = wfScheduledAdmission.AdmittingDiagnosis;
            if (wfScheduledAdmission.WardLocationId != null)
            {
                item.TypeOfBedWard = ward.Name;
            };            
            if (treatingSpecialty != null)
            {
                item.TypeOfBedWard = treatingSpecialty.displayName;
            }
            item.VistaSite = VistaSite;
            ConvertToUtc(item);
            item.CreationDate = DateTime.UtcNow;
            item.RequestedDate = DateTime.UtcNow;
            WFFactory.WaitingListFlowClientWindows.CreateWaitingListItem(item);
            Logger.LogFormat(BmsLogger.Level.Info, "Create Waiting List Item for patient {0}, {1} {2} with success",
                           item.Patient.LastName, item.Patient.FirstName, item.Patient.MiddleName);

            return true;
        }

        protected override DataContracts.VistaIntegrationLog MakeLog(WaitingListItem entity)
        {
            return VistaIntegrationLogFactory.MakeWaitingListLog(entity);
        }
    }
}
