﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using FC = BMS.Facade.Data;
using DC = BMS.DataContracts;
using InfoWorld.HL7.ITS;
using BMS.ServicesWrapper.WF;
using BMS.Utils;
using System.ServiceModel;
using BMS.Facade.Fault;
using BMS.ServicesWrapper.BMService;
using BMS.ServicesWrapper.EVS;
using BMS.ServicesWrapper.Security;
using System.Configuration;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.WF
{
    /// <summary>
    /// The EDISPatient admission writer.
    /// </summary>
    class EDISPatientAdmissionWriter : BaseWorkFlowWriter<EDISPatientAdmission>
    {
        private List<II> _facilitiesList = new List<II>();

        /// <summary>
        /// Sends the event.
        /// </summary>
        /// <param name="entity">The entity.</param>
        //protected override bool SendEvent(EDISPatientAdmission entity)
        //{
        //    if (_facilitiesList == null || _facilitiesList.Count == 0)
        //    {
        //        IList<FC.Facility> facilitiesByVista = EIS.GetFacilities(VistaSite.Id);
        //        _facilitiesList = facilitiesByVista.Select(facility => facility.Id).ToList();
        //    }

        //    string domainId = BMS.ServicesWrapper.Security.SecurityFactory.InstanceWindows.GetCurrentDomain();

        //    DC.AdmissionOrder wfAdmission = new DC.AdmissionOrder()
        //    {
        //        Id = new II(domainId, null),
        //        PatientId = MakePatient(entity.Patient),
        //        OrderedDate = entity.LogEntryTime,
        //        SignedDate = entity.DispositionTime,
        //        Ien = entity.IEN,
        //        OrderText = entity.Complaint,
        //        ReleasedDate = null,
        //        SignedById = null,
        //        ProviderId = null,
        //        HospitalLocationId = null,
        //        VistaSiteId = (VistaSite != null) ? VistaSite.Id : null,
        //        FacilityList = _facilitiesList,
        //        IsActive = true,
        //        WardId = null
        //    };

        //    ConvertToUtc(wfAdmission);
        //    BMSFactory.BedManagerOperationsClientWindows.CreateAdmissionOrder(wfAdmission);
        //    //UtilsInstance.SendMailNotification(orderAction, wfAdmission.VistaSiteId, VistATimeZone, Constants.ADMISSION_ORDER, null, wfAdmission.PatientId);
        //    Logger.LogFormat(BmsLogger.Level.Info, "Create admission order for patient {0} with succes", entity.Patient.Name);

        //    if (entity.Patient.IsOptOut)
        //    {
        //        // associate icon with this patient
        //        DC.IconAssociation iconAssociation = new DC.IconAssociation();
        //        iconAssociation.PatientId = wfAdmission.PatientId;
        //        iconAssociation.ListIconFlagIdsOfPatient = new List<int>() { 18 };
        //        BMSFactory.BedManagerOperationsClientWindows.InsertIconAssociation(iconAssociation);
        //    }

        //    return true;
        //}

        protected override bool SendEvent(EDISPatientAdmission entity)
        {
            FC.WaitingListItem item = new FC.WaitingListItem();
            IList<CD> cds = EVS.GetCodes(new CodeFilterParameters() { VocabularyDomain = BMS.Facade.Data.Util.Vocabulary.WaitingArea.ToString(), MaxSelectedCodes = int.MaxValue });
            item.WaitingArea = cds.FirstOrDefault(cd => cd.code == Constants.WAITING_AREA_SCHEDULED_ADMISSIONS);
            string domain = SecurityFactory.InstanceWindows.GetCurrentDomain();
            item.Id = new II(domain, null);
            item.Patient = MakeWfPatient(entity.Patient);
            
            item.RequestedBedDate = entity.DispositionTime;

            if (!string.IsNullOrEmpty(entity.FacilityCode))
            {
                IList<FC.Facility> facilities = BMS.ServicesWrapper.EIS.EISFactory.InstanceFromWCF.GetFacilitiesBySiteNumber(VistaSite.Number);
                foreach (FC.Facility facility in facilities)
                {
                    if (facility.SiteNumber == entity.FacilityCode)
                    {
                        item.Facility = facility;
                        break;
                    }
                }
            }
                
            item.Problem = entity.Complaint;

            if (item.Patient != null && item.Patient.TreatingSpecialty != null)
                item.TypeOfBedWard = item.Patient.TreatingSpecialty.displayName;

            // the type of bed ward may not be reliable given the incoming EDIS admit if it is obtained from the patient treating specialty
            item.TypeOfBedWard = "TBD";

            item.VistaSite = VistaSite;
            ConvertToUtc(item);
            item.CreationDate = DateTime.UtcNow;
            item.RequestedDate = DateTime.UtcNow;

            if (ConfigurationManager.AppSettings["FlagEDISAsInHouse"] != null && ConfigurationManager.AppSettings["FlagEDISAsInHouse"].ToString() == "true")
                item.IsInHouse = true; // this prevents EDIS patients from falling off the admit list immediately

            if (item.Facility == null)
            {
                Logger.LogFormat(BmsLogger.Level.Error, "Facility is null before create Waiting List Item for EDIS patient {0}, {1} {2} with success",
                           item.Patient.LastName, item.Patient.FirstName, item.Patient.MiddleName);
            }

            try
            {
                WFFactory.WaitingListFlowClientWindows.CreateWaitingListItem(item);
            }
            catch (Exception ex)
            {
                Logger.LogFormat(BmsLogger.Level.Error, "Failed to Create Waiting List Item for EDIS patient {0}, {1} {2} with error: {3}",
                           item.Patient.LastName, item.Patient.FirstName, item.Patient.MiddleName, ex.ToString());
            }

            Logger.LogFormat(BmsLogger.Level.Info, "Create Waiting List Item for EDIS patient {0}, {1} {2} with success",
                           item.Patient.LastName, item.Patient.FirstName, item.Patient.MiddleName);

            return true;
        }

        protected override DC.VistaIntegrationLog MakeLog(EDISPatientAdmission entity)
        {
            return new DC.VistaIntegrationLog()
            {
                File = DC.VistaFiles.EDISPatientAdmission,
                Ien = string.Format("{0}_{1}", entity.IEN, entity.DispositionTime.ToString("MM/dd/yyyy HH:mm:ss"))
            };
        }
    }
}
