﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;

using InfoWorld.HL7.ITS;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.ServicesWrapper.EVS;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.EVS
{
    /// <summary>
    /// The type of movement writer.
    /// </summary>
    class TypeOfMovementWriter : BaseEvsWriter<FacilityMovementType>
    {

        protected override string CodeSystem
        {
            get { return Constants.TypeOfMovementCodeSystem; }
        }

        protected override string CodeSystemName
        {
            get { return Util.Vocabulary.TypeOfMovement.ToString(); }
        }


        protected override IEntityDal<CD> Dal
        {
            get { return Data.TypeOfMovementDal; }
        }

        public override void InitCache()
        {
            Data.SetCacheForTypeOfMovement();
        }
    }
}
