﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.ServicesWrapper.EIS;
using BMS.ServicesWrapper.EVS;
using BMS.Facade.Data;
using BMS.VistaIntegration.Data;

namespace BMS.VistaWorker2.Writer.Implementation.Concrete.Dal
{
    public abstract class BaseDal<T> : IEntityDal<T>
         where T : class
    {
        public BaseDal(VistaSite site)
        {
            this.Site = site;
        }

        public VistaSite Site { get; private set; }

        public abstract T Get(IEntity vistaEntity);

        public abstract void Add(IEntity vistaEntity, T entity);

        public abstract void Delete(IEntity vistaEntity, T entity);

        public abstract void Update(IEntity vistaEntity, T entity);

        public static IEISWrapper EIS { get { return EISFactory.InstanceWindows; } }
        public static IEVSWrapper EVS { get { return EVSFactory.InstanceWindows; } }
    }
}
