﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Facade.Data;
using BMS.Utils;
using BMS.VistaWorker2.Writer.Implementation.Concrete.Dal;
using BMS.ServicesWrapper.Security;
using BMS.ServicesWrapper.EIS;
using BMS.VistaIntegration.Data;
using InfoWorld.HL7.ITS;
using BMS.VistaWorker2.Writer.Implementation.Concrete.DalCached;


namespace BMS.VistaWorker2.Writer.Implementation.Concrete
{
    public class CommonData
    {
        public WriterManager WriterManager { get; private set; }
        public VistaSite Site { get; private set; }
        public TimeZoneInfo TimeZone { get; private set; }
        public BmsLogger Logger { get; private set; }

        public CommonData(WriterManager writerManager, BmsLogger logger)
        {
            WriterManager = writerManager;
            InitVistaSite(writerManager.Site);
            this.Logger = logger;
            HospitalLocationDal = new HospitalLocationDal(Site);
            WardDal = new WardDal(Site);
            BedDal = new BedDal(Site);
            MedicalCenterDivisionDal = new EvsDal(Site, Util.Vocabulary.VistaMedicalCenterDivision.ToString());
            SpecialtyDal = new GlobalEvsDal(Site, Util.Vocabulary.VistaSpecialty.ToString());
            TreatingSpecialtyDal = new EvsDal(Site, Util.Vocabulary.VistaTreatingSpecialty.ToString());
            TypeOfMovementDal = new EvsDal(Site, Util.Vocabulary.TypeOfMovement.ToString());
            OrderableItemDal = new EvsDal(Site, Util.Vocabulary.OrderableItem.ToString());
            PatientDal = new PatientDal(Site);
            BedUnavailableDal = new BedUnavailableDal(Site);
            PersonDal = new NewPersonDal(Site);
        }

        public BedUnavailableDal BedUnavailableDal { get; private set; }
        public IEntityDal<BMS.Facade.Data.HospitalLocation> HospitalLocationDal { get; private set; }
        public IEntityDal<Ward> WardDal { get; private set; }
        public IEntityDal<Bed> BedDal { get; private set; }
        public IEntityDal<CD> MedicalCenterDivisionDal { get; private set; }
        public IEntityDal<CD> SpecialtyDal { get; private set; }
        public IEntityDal<CD> TreatingSpecialtyDal { get; private set; }
        public IEntityDal<CD> TypeOfMovementDal { get; private set; }
        public IEntityDal<CD> OrderableItemDal { get; private set; }
        public IEntityDal<BMS.Facade.Data.Patient> PatientDal { get; private set; }
        public IEntityDal<BMS.Facade.Data.Person> PersonDal { get; private set; }

        public void SetCacheForHospitalLocation()
        {
            if (HospitalLocationDal is HospitalLocationDal)
            {
                HospitalLocationDal = new HospitalLocationCachedDal(HospitalLocationDal);
            }
        }

        public void SetCacheForWard()
        {
            if (WardDal is WardDal)
            {
                WardDal = new WardCachedDal(WardDal);
            }
        }

        public void SetCacheForBed()
        {
            SetCacheForWard();
            if (BedDal is BedDal)
            {
                BedDal = new BedCachedDal(BedDal);
            }
        }

        public void SetCacheForMedicalCenterDivision()
        {
            MedicalCenterDivisionDal = SetCacheForEvs(MedicalCenterDivisionDal);
        }

        public void SetCacheForSpecialty()
        {
            SpecialtyDal = SetCacheForEvs(SpecialtyDal);
        }

        public void SetCacheForTreatingSpecialty()
        {
            TreatingSpecialtyDal = SetCacheForEvs(TreatingSpecialtyDal);
        }

        public void SetCacheForTypeOfMovement()
        {
            TypeOfMovementDal = SetCacheForEvs(TypeOfMovementDal);
        }

        public void SetCacheForOrderableItem()
        {
            OrderableItemDal = SetCacheForEvs(OrderableItemDal);
        }

        private IEntityDal<CD> SetCacheForEvs(IEntityDal<CD> dal)
        {
            EvsDal evsDal = dal as EvsDal;
            if (evsDal != null)
            {
                return new EvsCachedDal(evsDal);
            }

            GlobalEvsDal globalEvsDal = dal as GlobalEvsDal;
            if (globalEvsDal != null)
            {
                return  new GlobalEvsCachedDal(globalEvsDal);
            }
            return dal;
        }

        private void InitVistaSite(VistASite site)
        {
            if (site == null)
                throw new ArgumentNullException();

            string domain = SecurityFactory.InstanceWindows.GetCurrentDomain();
            Site = EISFactory.InstanceWindows.GetVistaSite(new InfoWorld.HL7.ITS.II(domain, site.Id));
            if (Site == null)
            {
                String msj = string.Format("No vistA site for {0}", site.Name);
                throw new InvalidOperationException(msj);
            }
            TimeZone = site.TimeZone;
        }

    }
}
