﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Data
{
    /// <summary>
    /// Vista orders orderable item entity.
    /// </summary>
    [Serializable]
    public class OrdersOrderableItem
    {
        /// <summary>
        /// Gets or sets the order id (IEN).
        /// </summary>
        /// <value>
        /// The order id.
        /// </value>
        public string OrderId { get; set; }

        /// <summary>
        /// Gets or sets the orderable item id.
        /// </summary>
        /// <value>
        /// The orderable item id.
        /// </value>
        public int OrderableItemId { get; set; }

        /// <summary>
        /// Gets or sets the orderable item.
        /// </summary>
        /// <value>
        /// The orderable item.
        /// </value>
        public OrderableItem OrderableItem { get; set; }

    }
}
