﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker;
using BMS.VistaWorker.Data;
using BMS.VistaWorker.Reader.Abstract;
using BMS.VistaWorker.Abstract;

namespace BMS.VistaWorker.Reader.Concrete.Entities
{
    /// <summary>
    /// The hospital location log data.
    /// </summary>
    public class HospitalLocationLog : BaseEisEvsLogData<HospitalLocation>
    {


        /// <summary>
        /// Gets the crud action.k
        /// </summary>
        public override CrudAction CrudAction { get; set; }


        /// <summary>
        /// Gets the id.
        /// </summary>
        public override int Id { get; set; }

        /// <summary>
        /// Gets or sets the action.
        /// </summary>
        /// <value>
        /// The action.
        /// </value>
        public char Action { get { return TranslateCrudAction.ToChar(CrudAction); } set { CrudAction = TranslateCrudAction.ToEnum(value); } }

        /// <summary>
        /// Gets the create date time.
        /// </summary>
        public override DateTime CreateDateTime { get; set; }

        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public int IEN { get { return Convert.ToInt32(entity.IEN); } set { entity.IEN = value + ""; } }
        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get { return entity.Name; } set { entity.Name = value; } }
        /// <summary>
        /// Gets or sets the abbreviation.
        /// </summary>
        /// <value>
        /// The abbreviation.
        /// </value>
        public string Abbreviation { get { return entity.Abbreviation; } set { entity.Abbreviation = value; } }
        /// <summary>
        /// Gets or sets the telephone.
        /// </summary>
        /// <value>
        /// The telephone.
        /// </value>
        public string Telephone { get { return entity.Telephone; } set { entity.Telephone = value; } }

    }
}
