﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaWorker.Abstract;
using BMS.VistaWorker.Reader.Concrete;

namespace BMS.VistaWorker.Reader.Abstract
{



    /// <summary>
    /// Interface implemented by all the data reader log classes. These classes are responsible for reading the database log.
    /// </summary>
    public interface ILogData
    {
        /// <summary>
        /// Gets the create date time.
        /// </summary>
        DateTime CreateDateTime { get; }

        /// <summary>
        /// Gets the entity.
        /// </summary>
        IEntity Entity { get; }

        /// <summary>
        /// Gets the id.
        /// </summary>
        int Id { get; }

        /// <summary>
        /// Gets the crud action.
        /// </summary>
        CrudAction CrudAction { get; }

    }
}
