﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Data;
using BMS.VistaIntegration.Mdws2.Entities;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Mdws2.Maps.Entities;
using BMS.VistaIntegration.Mdws2.Maps.EIS;

namespace BMS.VistaIntegration.Mdws2.Maps.WF
{
    public class PatientAppointmentClinicMap : SubFileMap<ClinicApp, PatientApp>
    {
        private static PatientAppointmentClinicMap _instance = new PatientAppointmentClinicMap();

        public static PatientAppointmentClinicMap Instance { get { return _instance; } }

        private PatientAppointmentClinicMap()
            : base(ClinicAppMap.Instance)
        {
        }

    
        public override string SubFileNumber
        {
            get { return "44.003"; }
        }

        public override string FieldIenForSubFile
        {
            get { return "2"; }
        }

        public override string FirstFieldIenForSubFile
        {
            get { return ".01"; }
        }

        public override PatientApp MakeSubFile(ClinicApp file)
        {
            return new PatientApp()
            {
                AppointmentDateTime = file.AppointmentDateTime
            };
        }

        protected override void Map()
        {
            Map((m, s) => m.PatientIen = s, ".01");
        }
    }
}
