﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Data;

namespace BMS.VistaIntegration.Mdws2.Maps.EVS
{
    public class OrderableItemMap : FileMap<OrderableItem>
    {
        private static readonly OrderableItemMap instance = new OrderableItemMap();
        public static OrderableItemMap Instance { get { return instance; } }

        private OrderableItemMap()
        {
        }

        public override string FileNumber
        {
            get { return "101.43"; }
        }

        protected override void Map()
        {
            MapIen((m, s) => m.IEN = s);
            Map((m, s) => m.Name = s, ".01");
            Map((m, s) => m.Inactivated = s, ".1");
            Map((m, s) => m.PackageName = s, "1.1");
            Map((m, s) => m.DisplayGroupId = s, "5");
        }
    }
}
