﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.Abstract;
using BMS.VistaIntegration.Mdws2.QuerySvcService;

namespace BMS.VistaIntegration.Mdws2.Abstract
{
    public class ListFetchCommand
    {

        public QuerySvcSoap Client { get; private set; }
        private IResultMaker ResultMaker { get; set; }

        public ListFetchCommand(QuerySvcSoap client)
        {
            this.Client = client;
            InitParam();
        }

        private void InitParam()
        {
            IensParam = string.Empty;
            FlagsParam = string.Empty;
            NumberParam = string.Empty;
            FromParam = string.Empty;
            PartialParam = string.Empty;
            IndexParam = "#";
            ScreenParam = string.Empty;
            IdentityParam = string.Empty;
            FileParam = string.Empty;
            FieldParam = string.Empty;
        }

        public int FieldsCount { get; set; }
        public string FileParam { get; set; }
        public string FieldParam { get; set; }
        public string IensParam { get; set; }
        public string FlagsParam { get; set; }
        public string NumberParam { get; set; }
        public string FromParam { get; set; }
        public string PartialParam { get; set; }
        public string IndexParam { get; set; }
        public string ScreenParam { get; set; }
        public string IdentityParam { get; set; }
        public string MultipleFieldsParam { get; set; }
        public string GetFieldsParam { get; set; }

        private TaggedTextArray RunRpc()
        {

            return Client.LIST_DIC(
                FileParam,
                IensParam,
                FieldParam,
                FlagsParam,
                NumberParam,
                FromParam,
                PartialParam,
                IndexParam,
                ScreenParam,
                IdentityParam);

        }

        public string LastIen { get; private set; }
        public int EntriesCount { get; private set; }

        private void ProcessResult(string text)
        {

            string[] lines = text.Split('\n');
            int length = lines.Length - 1;
            EntriesCount = length / FieldsCount;
            ResultMaker.InitEntries(EntriesCount);

            for (int i = 0; i < length; i += FieldsCount)
            {
                ProcessNewLine(lines[i]);
                for (int j = 1; j < FieldsCount; j++)
                    ProcessLine(lines[i + j]);
                if (MultipleFieldsParam != null)
                {
                    ProcessMultipleFields();
                }
                if (GetFieldsParam != null)
                {
                    ProcessGetFields();
                }
                ResultMaker.AddLastEntryToResult();
            }

        }

        private void ProcessGetFields()
        {
            string iens = LastIen;
            if (!string.IsNullOrEmpty(IensParam)) iens += IensParam;
            TaggedTextArray result = Client.GETS_DIQ(
            fileNumber: FileParam,
            iens: iens,
            field: GetFieldsParam,
            flags: "NI");

            if (result.fault != null)
                throw result.fault.MakeExceptionFromVistAFault();
            string text = result.results[0].text;
            if (text == "-1^No data retrieved\n")
                return;

            string[] lines = text.Split('\n');
            for (int i = 0; i < lines.Length - 1; i++)
                ProcessLineForGetFields(lines[i]);
        }

        private void ProcessLineForGetFields(string line)
        {
            string[] values = line.Split('^');
            string fileNumber = values[0];
            string fieldIen = values[2];
            string value = values[3];
            if (value != string.Empty && fileNumber == FileParam)
                ResultMaker.SetFieldForLastEntry(fieldIen, value);

        }

        private void ProcessMultipleFields()
        {
            string iens = LastIen;
            if (!string.IsNullOrEmpty(IensParam)) iens += IensParam;
            TaggedTextArray result = Client.GETS_DIQ(
            fileNumber: FileParam,
            iens: iens,
            field: MultipleFieldsParam,
            flags: "NI");

            if (result.fault != null)
                throw result.fault.MakeExceptionFromVistAFault();
            string text = result.results[0].text;
            if (text == "-1^No data retrieved\n")
                return;
            string[] lines = text.Split('\n');
            for (int i = 0; i < lines.Length - 1; i++)
                ProcessLineForMultipleFields(lines[i]);

        }

        private void ProcessLineForMultipleFields(string line)
        {

            string[] values = line.Split('^');
            string subFileNumber = values[0];
            string fieldIen = values[2];
            string value = values[3];
            if (value != string.Empty)
                ResultMaker.SetMultipleFieldForLastEntry(subFileNumber, fieldIen, value);

        }


        private void ProcessNewLine(string line)
        {

            string[] values = line.Split('^');
            LastIen = values[1];
            string fieldIen = values[2];
            string value = values[3];
            ResultMaker.AddNewEntry(LastIen);
            if (value != string.Empty)
                ResultMaker.SetFieldForLastEntry(fieldIen, value);

        }

        private void ProcessLine(String line)
        {

            string[] values = line.Split('^');
            string LastIen = values[1];
            string fieldIen = values[2];
            string value = values[3];
            if (value != string.Empty)
                ResultMaker.SetFieldForLastEntry(fieldIen, value);

        }

        public void Execute(IResultMaker resultMaker)
        {

            ResultMaker = resultMaker;
            TaggedTextArray result = RunRpc();
            if (result.fault != null)
                throw result.fault.MakeExceptionFromVistAFault();
            string text = result.results[0].text;
                if (result.results[0].fault != null) throw result.results[0].fault.MakeExceptionFromVistAFault();
            ProcessResult(text);
        }
    }
}
