﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.QuerySvcService;

namespace BMS.VistaIntegration.Mdws2.Abstract
{
    public class FileFetch<T> : IVistAQuery<T>
        where T : class , new()
    {
        public FileMap<T> FileMap { get; private set; }

        public FileFetch(FileMap<T> fileMap)
        {
            this.FileMap = fileMap;
        }

        public Predicate<T> FilterPredicate { get; set; }

        private class ResultMaker : IResultMaker
        {
            public List<T> Result { get; private set; }
            private T lastEntry;
            private readonly FileMap<T> fileMap;
            private readonly Predicate<T> filterPredicate;
            private readonly QuerySvcSoap client;
   

            public ResultMaker(FileFetch<T> fileFetch)
            {
                this.fileMap = fileFetch.FileMap;
                this.filterPredicate = fileFetch.FilterPredicate;
                this.client = fileFetch.Client;
            }

            public void InitEntries(int capacity)
            {
                Result = new List<T>(capacity);
            }


            public void AddNewEntry(string ien)
            {
                lastEntry = fileMap.Make();
                fileMap.SetIen(lastEntry, ien);

            }

            public void AddLastEntryToResult()
            {
                if (filterPredicate == null || filterPredicate(lastEntry))
                    Result.Add(lastEntry);
                lastEntry = null;
            }


            public void SetMultipleFieldForLastEntry(string subFileNumber, string fieldIen, string value)
            {
                fileMap.SetMultipleField(lastEntry, subFileNumber, fieldIen, value);
            }


            public void SetFieldForLastEntry(string fieldIen, string value)
            {
                fileMap.SetField(lastEntry, fieldIen, value);
                var reference = fileMap.GetReference(fieldIen);
                if (reference != null)
                {
                    reference.SetFields(client, lastEntry, value);
                }
            }
        }

        public string ScreenParam { get; set; }
        public int? BulkCount { get; set; }
        public string FromParam { get; set; }
        public string IndexParam { get; set; }
        public QuerySvcSoap Client { get; set; }
        public string Iens { get; set; }
        public string LastIen { get; private set; }
        public bool HasMore { get; private set; }

        public IList<T> GetResult()
        {

            ListFetchCommand command = new ListFetchCommand(Client);
            command.FileParam = FileMap.FileNumber;
            command.FieldParam = FileMap.FieldsParam;
            command.FieldsCount = FileMap.FieldsCount;
            command.MultipleFieldsParam = FileMap.MultipleFieldsParam;
            command.GetFieldsParam = FileMap.GetFieldsParam;
            command.FlagsParam = FileMap.FlagsParam;
            if (ScreenParam != null)
                command.ScreenParam = ScreenParam;
            if (BulkCount.HasValue)
                command.NumberParam = BulkCount.ToString();
            if (IndexParam != null)
                command.IndexParam = IndexParam;
            if (FromParam != null)
                command.FromParam = FromParam;
            if (Iens != null)
                command.IensParam = Iens;
            ResultMaker maker = new ResultMaker(this);
            command.Execute(maker);
            LastIen = command.LastIen;
            HasMore = BulkCount.HasValue ? command.EntriesCount >= BulkCount.Value : false;
            return maker.Result;

        }



    }
}
