﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    [Serializable]
    public class PatientMovementIen : IEntity
    {
        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the movement date.
        /// </summary>
        /// <value>
        /// The movement date.
        /// </value>
        public DateTime MovementDate { get; set; }

        /// <summary>
        /// Gets or sets the entered date.
        /// </summary>
        /// <value>
        /// The entered date.
        /// </value>
        public DateTime EnteredDate { get; set; }

        /// <summary>
        /// Gets or sets the ward location id.
        /// </summary>
        /// <value>
        /// The ward location id.
        /// </value>
        public string WardLocationId { get; set; }

        /// <summary>
        /// Gets or sets the room bed id.
        /// </summary>
        /// <value>
        /// The room bed id.
        /// </value>
        public string RoomBedId { get; set; }

        /// <summary>
        /// Gets or sets the patient ien.
        /// </summary>
        /// <value>
        /// The patient ien.
        /// </value>
        public string PatientIen { get; set; }

        /// <summary>
        /// Gets or sets the current admission ien.
        /// </summary>
        /// <value>
        /// The current admission ien.
        /// </value>
        public string CurrentAdmissionIen { get; set; }

        /// <summary>
        /// Gets or sets the type of movement ien.
        /// </summary>
        /// <value>
        /// The type of movement ien.
        /// </value>
        public string TypeOfMovementIen { get; set; }

        /// <summary>
        /// Gets or sets the transaction type id.
        /// </summary>
        /// <value>
        /// The transaction type id.
        /// </value>
        public string TransactionTypeId { get; set; }
    }
}
