﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.VistaIntegration.Data
{
    /// <summary>
    /// VistA medical center division contract.
    /// </summary>
    [Serializable]      
    public class MedicalCenterDivision : IConcept
    {
        /// <summary>
        /// Gets or sets the IEN.
        /// </summary>
        /// <value>
        /// The IEN.
        /// </value>
        
        public string IEN { get; set; }

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the facility number.
        /// </summary>
        /// <value>
        /// The facility number.
        /// </value>
        
        public string FacilityNumber { get; set; }

        public override string ToString()
        {
            return "MedicalCenterDivision:" + Name;
        }
    }
}
