﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;
using System.Collections;
using System.Collections.Generic;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about waiting list items (patients waiting).
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "WaitingListItem")]
    [DataContract(Name = "WaitingListItem")]    
    [KnownType(typeof(CD))]
    [KnownType(typeof(II))]
    [KnownType(typeof(Act))]
    public class WaitingListItem : Act
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the date of the removal from the waiting list.
        /// </summary>
        /// <value>
        /// The removal date.
        /// </value>
        [XmlElementAttribute("RemovedDate", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "RemovedDate", Order = 1)]
        public DateTime? RemovedDate { get; set; }

        /// <summary>
        /// Gets or sets the date of the admission request.
        /// </summary>
        /// <value>
        /// The date of the request.
        /// </value>
        [XmlElementAttribute("RequestedDate", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "RequestedDate", Order = 2)]
        public DateTime? RequestedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the illness is acute (fee disposition).
        /// </summary>
        /// <value>
        /// The fee disposition.
        /// </value>
        [XmlElementAttribute("FeeDisposition", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "FeeDisposition", Order = 3)]
        public CD FeeDisposition { get; set; }

        /// <summary>
        /// Gets or sets the comment for the fee.
        /// </summary>
        /// <value>
        /// The comment for the fee.
        /// </value>
        [XmlElementAttribute("CommentFee", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "CommentFee", Order = 4)]
        public string CommentFee { get; set; }

        /// <summary>
        /// Gets or sets the reason for the fee(EVS concept).
        /// </summary>
        /// <value>
        /// The reason for the fee.
        /// </value>
        [XmlElementAttribute("ReasonFee", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "ReasonFee", Order = 5)]
        public CD ReasonFee { get; set; }

        /// <summary>
        /// Gets or sets the received service for the fee(EVS concept).
        /// </summary>
        /// <value>
        /// The service received.
        /// </value>
        [XmlElementAttribute("ServiceReceive", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "ServiceReceive", Order = 6)]
        public CD ServiceReceive { get; set; }

        /// <summary>
        /// Gets or sets the value indicating if the fee was authorized or not(EVS concept).
        /// </summary>
        /// <value>
        /// The authorization.
        /// </value>
        [XmlElementAttribute("Authorization", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "Authorization", Order = 7)]
        public CD Authorization { get; set; }

        /// <summary>
        /// Gets or sets whether there is a contract concerning the fee.
        /// </summary>
        /// <value>
        /// The contract.
        /// </value>
        [XmlElementAttribute("Contract", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "Contract", Order = 8)]
        public CD Contract { get; set; }

        /// <summary>
        /// Gets or sets the problem. Name of the presented problem or diagnostic of  the patient.
        /// </summary>
        /// <value>
        /// The problem.
        /// </value>
        [XmlElementAttribute("Problem", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "Problem", Order = 9)]
        public string Problem { get; set; }

        /// <summary>
        /// Gets or sets the type of bed or ward needed by the patient(EVS patient).
        /// </summary>
        /// <value>
        /// The type of bed ward.
        /// </value>
        [XmlElementAttribute("TypeOfBedWard", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "TypeOfBedWard", Order = 10)]
        public string TypeOfBedWard { get; set; }

        /// <summary>
        /// Gets or sets the area where the patient waits for admission(EVS concept).
        /// </summary>
        /// <value>
        /// The waiting area.
        /// </value>
        [XmlElementAttribute("WaitingArea", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "WaitingArea", Order = 11)]
        public CD WaitingArea { get; set; }

        /// <summary>
        /// Gets or sets the facility where the patient will be admitted.
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 12)]
        public II FacilityId { get; set; }

        /// <summary>
        /// Gets or sets the requested bed.
        /// </summary>
        /// <value>
        /// The requested bed.
        /// </value>
        [XmlElementAttribute("RequestedBedId", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "RequestedBedId", Order = 13)]
        public II RequestedBedId { get; set; }

        /// <summary>
        /// Gets or sets the requested bed date.
        /// </summary>
        /// <value>
        /// The requested bed date.
        /// </value>
        [XmlElementAttribute("RequestedBedDate", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "RequestedBedDate", Order = 14)]
        public DateTime? RequestedBedDate { get; set; }

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [XmlElementAttribute("VistaSiteId", Order = 15)]
        [DataMember(EmitDefaultValue = false, Name = "VistaSiteId", Order = 15)]
        public II VistaSiteId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating if patient already admitted to current facility.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is in house; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsInHouse", Order = 16)]
        [DataMember(EmitDefaultValue = false, Name = "IsInHouse", Order = 16)]
        public bool IsInHouse { get; set; }

        /// <summary>
        /// Gets or sets the last edit by.
        /// </summary>
        /// <value>
        /// The last edit by.
        /// </value>
        [XmlElementAttribute("LastEditBy", Order = 17)]
        [DataMember(EmitDefaultValue = false, Name = "LastEditBy", Order = 17)]
        public string LastEditBy { get; set; }

        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        /// <value>
        /// The comments.
        /// </value>
        [XmlElementAttribute("Comments", Order = 18)]
        [DataMember(EmitDefaultValue = false, Name = "Comments", Order = 18)]
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether bed is in isolation or not.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if bed is in isolation; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsBedInIsolation", Order = 19)]
        [DataMember(EmitDefaultValue = false, Name = "IsBedInIsolation", Order = 19)]
        public bool IsBedInIsolation { get; set; }

        /// <summary>
        /// Gets or sets the wait time alert date.
        /// </summary>
        /// <value>
        /// The wait time alert date.
        /// </value>
        [XmlElementAttribute("WaitTimeAlertDate", Order = 20)]
        [DataMember(EmitDefaultValue = false, Name = "WaitTimeAlertDate", Order = 20)]
        public DateTime? WaitTimeAlertDate { get; set; }

        /// <summary>
        /// Gets or sets the community living center.
        /// </summary>
        /// <value>
        /// The community living center.
        /// </value>
        [XmlElementAttribute("IsCommunityLivingCenter", Order = 21)]
        [DataMember(EmitDefaultValue = false, Name = "IsCommunityLivingCenter", Order = 21)]
        public bool IsCommunityLivingCenter { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is evacuation patient.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is evacuation patient; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsEvacuationPatient", Order = 22)]
        [DataMember(EmitDefaultValue = false, Name = "IsEvacuationPatient", Order = 22)]
        public bool IsEvacuationPatient { get; set; }

        [XmlElementAttribute("IsMentalHealthPatient", Order = 23)]
        [DataMember(EmitDefaultValue = false, Name = "IsMentalHealthPatient", Order = 23)]
        public bool IsMentalHealthPatient { get; set; }

        /// <summary>
        /// Gets or sets the evacuation disposition status.
        /// </summary>
        /// <value>
        /// The evacuation disposition status.
        /// </value>
        [XmlElementAttribute("EvacuationDispositionStatus", Order = 24)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationDispositionStatus", Order = 24)]
        public CD EvacuationDispositionStatus { get; set; }

        /// <summary>
        /// Gets or sets the evacuation expected date.
        /// </summary>
        /// <value>
        /// The evacuation expected date.
        /// </value>
        [XmlElementAttribute("EvacuationExpectedDate", Order = 25)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationExpectedDate", Order = 25)]
        public DateTime? EvacuationExpectedDate{ get; set; }

        /// <summary>
        /// Gets or sets the evacuation actual date.
        /// </summary>
        /// <value>
        /// The evacuation actual date.
        /// </value>
        [XmlElementAttribute("EvacuationActualDate", Order = 26)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationActualDate", Order = 26)]
        public DateTime? EvacuationActualDate { get; set; }

        /// <summary>
        /// Gets or sets the evacuation reason for delay.
        /// </summary>
        /// <value>
        /// The evacuation reason for delay.
        /// </value>
        [XmlElementAttribute("EvacuationReasonForDelay", Order = 27)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationReasonForDelay", Order = 27)]
        public string EvacuationReasonForDelay { get; set; }

        /// <summary>
        /// Gets or sets the evacuation transfer evacuate to.
        /// </summary>
        /// <value>
        /// The evacuation transfer evacuate to.
        /// </value>
        [XmlElementAttribute("EvacuationTransferEvacuateTo", Order = 28)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationTransferEvacuateTo", Order = 28)]
        public string EvacuationTransferEvacuateTo { get; set; }

        /// <summary>
        /// Gets or sets the evacuation equip supply requirements.
        /// </summary>
        /// <value>
        /// The evacuation equip supply requirements.
        /// </value>
        [XmlElementAttribute("EvacuationEquipSupplyRequirements", Order = 29)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationEquipSupplyRequirements", Order = 29)]
        public string EvacuationEquipSupplyRequirements { get; set; }

        /// <summary>
        /// Gets or sets the evacuation transportation care level.
        /// </summary>
        /// <value>
        /// The evacuation transportation care level.
        /// </value>
        [XmlElementAttribute("EvacuationTransportationCareLevel", Order = 30)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationTransportationCareLevel", Order = 30)]
        public string EvacuationTransportationCareLevel { get; set; }

        /// <summary>
        /// Gets or sets the evacuation enroute medical attendant.
        /// </summary>
        /// <value>
        /// The evacuation enroute medical attendant.
        /// </value>
        [XmlElementAttribute("EvacuationEnrouteMedicalAttendant", Order = 31)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationEnrouteMedicalAttendant", Order = 31)]
        public string EvacuationEnrouteMedicalAttendant { get; set; }

        /// <summary>
        /// Gets or sets the evacuation enroute non medical attendant.
        /// </summary>
        /// <value>
        /// The evacuation enroute non medical attendant.
        /// </value>
        [XmlElementAttribute("EvacuationEnrouteNonMedicalAttendant", Order = 32)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationEnrouteNonMedicalAttendant", Order = 32)]
        public string EvacuationEnrouteNonMedicalAttendant { get; set; }

        /// <summary>
        /// Gets or sets the type of the evacuation transportation.
        /// </summary>
        /// <value>
        /// The type of the evacuation transportation.
        /// </value>
        [XmlElementAttribute("EvacuationTransportationType", Order = 33)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationTransportationType", Order = 33)]
        public CD EvacuationTransportationType { get; set; }

        /// <summary>
        /// Gets or sets the evacuation transportation provider.
        /// </summary>
        /// <value>
        /// The evacuation transportation provider.
        /// </value>
        [XmlElementAttribute("EvacuationTransportationProvider", Order = 34)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationTransportationProvider", Order = 34)]
        public CD EvacuationTransportationProvider { get; set; }

        /// <summary>
        /// Gets or sets the evacuation transportation comments.
        /// </summary>
        /// <value>
        /// The evacuation transportation comments.
        /// </value>
        [XmlElementAttribute("EvacuationTransportationComments", Order = 35)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationTransportationComments", Order = 35)]
        public string EvacuationTransportationComments { get; set; }

        /// <summary>
        /// Gets or sets the evacuation destination address.
        /// </summary>
        /// <value>
        /// The evacuation destination address.
        /// </value>
        [XmlElementAttribute("EvacuationDestinationAddress", Order = 36)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationDestinationAddress", Order = 36)]
        public string EvacuationDestinationAddress { get; set; }

        /// <summary>
        /// Gets or sets the state of the evacuation destination city.
        /// </summary>
        /// <value>
        /// The state of the evacuation destination city.
        /// </value>
        [XmlElementAttribute("EvacuationDestinationCityState", Order = 37)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationDestinationCityState", Order = 37)]
        public string EvacuationDestinationCityState { get; set; }

        /// <summary>
        /// Gets or sets the evacuation destination POC telephone.
        /// </summary>
        /// <value>
        /// The evacuation destination POC telephone.
        /// </value>
        [XmlElementAttribute("EvacuationDestinationPOCTelephone", Order = 38)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationDestinationPOCTelephone", Order = 38)]
        public string EvacuationDestinationPOCTelephone { get; set; }

        /// <summary>
        /// Gets or sets the evacuation originator POC telephone.
        /// </summary>
        /// <value>
        /// The evacuation originator POC telephone.
        /// </value>
        [XmlElementAttribute("EvacuationOriginatorPOCTelephone", Order = 39)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationOriginatorPOCTelephone", Order = 39)]
        public string EvacuationOriginatorPOCTelephone { get; set; }

        /// <summary>
        /// Gets or sets the evacuation comments.
        /// </summary>
        /// <value>
        /// The evacuation comments.
        /// </value>
        [XmlElementAttribute("EvacuationComments", Order = 40)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationComments", Order = 40)]
        public string EvacuationComments { get; set; }

        /// <summary>
        /// Gets or sets the evacuation enroute medical attendant number.
        /// </summary>
        /// <value>
        /// The evacuation enroute medical attendant number.
        /// </value>
        [XmlElementAttribute("EvacuationEnrouteMedicalAttendantNumber", Order = 41)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationEnrouteMedicalAttendantNumber", Order = 41)]
        public int? EvacuationEnrouteMedicalAttendantNumber { get; set; }

        /// <summary>
        /// Gets or sets the evacuation enroute non medical attendant number.
        /// </summary>
        /// <value>
        /// The evacuation enroute non medical attendant number.
        /// </value>
        [XmlElementAttribute("EvacuationEnrouteNonMedicalAttendantNumber", Order = 42)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationEnrouteNonMedicalAttendantNumber", Order = 42)]
        public int? EvacuationEnrouteNonMedicalAttendantNumber { get; set; }

        /// <summary>
        /// Gets or sets the evacuation arrival time at the destination.
        /// </summary>
        /// <value>
        /// The evacuation arrival time.
        /// </value>
        [XmlElementAttribute("EvacuationArrivalTime", Order = 43)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationArrivalTime", Order = 43)]
        public DateTime? EvacuationArrivalTime { get; set; }

        /// <summary>
        /// Gets or sets the evacuation vehicle's ID.
        /// </summary>
        /// <value>
        /// The evacuation vehicle ID.
        /// </value>
        [XmlElementAttribute("EvacuationVehicleID", Order = 44)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationVehicleID", Order = 44)]
        public string EvacuationVehicleID { get; set; }

        /// <summary>
        /// Gets or sets the evacuation vehicle seat position of the evacuee.
        /// </summary>
        /// <value>
        /// The evacuee's seat position.
        /// </value>
        [XmlElementAttribute("EvacuationVehicleSeatPosition", Order = 45)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationVehicleSeatPosition", Order = 45)]
        public string EvacuationVehicleSeatPosition { get; set; }

        /// <summary>
        /// Gets or sets the evacuation medical attendant's telephone.
        /// </summary>
        /// <value>
        /// The evacuation medical attendant's telephone.
        /// </value>
        [XmlElementAttribute("EvacuationMATelephone", Order = 46)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationMATelephone", Order = 46)]
        public string EvacuationMATelephone { get; set; }

        /// <summary>
        /// Gets or sets the evacuation non-medical attendant's telephone.
        /// </summary>
        /// <value>
        /// The evacuation non-medical attendant's telephone.
        /// </value>
        [XmlElementAttribute("EvacuationNMATelephone", Order = 47)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationNMATelephone", Order = 47)]
        public string EvacuationNMATelephone { get; set; }

        /// <summary>
        /// Gets or sets the evacuation originating facility name.
        /// </summary>
        /// <value>
        /// The evacuation originating facility name.
        /// </value>
        [XmlElementAttribute("EvacuationOriginatingFacilityName", Order = 48)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationOriginatingFacilityName", Order = 48)]
        public string EvacuationOriginatingFacilityName { get; set; }

        /// <summary>
        /// Gets or sets the evacuation originating address.
        /// </summary>
        /// <value>
        /// The evacuation originating address.
        /// </value>
        [XmlElementAttribute("EvacuationOriginatingAddress", Order = 49)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationOriginatingAddress", Order = 49)]
        public string EvacuationOriginatingAddress { get; set; }

        /// <summary>
        /// Gets or sets the state of the evacuation originating city.
        /// </summary>
        /// <value>
        /// The state of the evacuation originating city.
        /// </value>
        [XmlElementAttribute("EvacuationOriginatingCityState", Order = 50)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationOriginatingCityState", Order = 50)]
        public string EvacuationOriginatingCityState { get; set; }

        /// <summary>
        /// Gets or sets the state of the evacuation vehicle operator name.
        /// </summary>
        /// <value>
        /// The state of the evacuation vehicle operator name.
        /// </value>
        [XmlElementAttribute("EvacuationVehicleOperatorName", Order = 51)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationVehicleOperatorName", Order = 51)]
        public string EvacuationVehicleOperatorName { get; set; }

        /// <summary>
        /// Gets or sets the evacuation vehicle operator's telephone.
        /// </summary>
        /// <value>
        /// The evacuation vehicle operator's telephone.
        /// </value>
        [XmlElementAttribute("EvacuationVehicleOperatorTelephone", Order = 52)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationVehicleOperatorTelephone", Order = 52)]
        public string EvacuationVehicleOperatorTelephone { get; set; }

        [XmlElementAttribute("DateOfScreening", Order = 53)]
        [DataMember(EmitDefaultValue = false, Name = "DateOfScreening", Order = 53)]
        public DateTime? DateOfScreening { get; set; }

        [XmlElementAttribute("ContactPhoneNumber", Order = 54)]
        [DataMember(EmitDefaultValue = false, Name = "ContactPhoneNumber", Order = 54)]
        public string ContactPhoneNumber { get; set; }

        [XmlElementAttribute("VeteranPreference", Order = 55)]
        [DataMember(EmitDefaultValue = false, Name = "VeteranPreference", Order = 55)]
        public string VeteranPreference { get; set; }

        [XmlElementAttribute("MentalHealthComment", Order = 56)]
        [DataMember(EmitDefaultValue = false, Name = "MentalHealthComment", Order = 56)]
        public string MentalHealthComment { get; set; }

        [XmlElementAttribute("PatientFlowComment", Order = 57)]
        [DataMember(EmitDefaultValue = false, Name = "PatientFlowComment", Order = 57)]
        public string PatientFlowComment { get; set; }

        [XmlElementAttribute("FeeAccepted", Order = 58)]
        [DataMember(EmitDefaultValue = false, Name = "FeeAccepted", Order = 58)]
        public string FeeAccepted { get; set; }

        [XmlElementAttribute("FeeAcceptingMD", Order = 59)]
        [DataMember(EmitDefaultValue = false, Name = "FeeAcceptingMD", Order = 59)]
        public string FeeAcceptingMD { get; set; }

        [XmlElementAttribute("EvacuationOriginatingPOC", Order = 60)]
        [DataMember(EmitDefaultValue = false, Name = "EvacuationOriginatingPOC", Order = 60)]
        public string EvacuationOriginatingPOC { get; set; }

        [XmlElementAttribute("IsCommunityHospital", Order = 61)]
        [DataMember(EmitDefaultValue = false, Name = "IsCommunityHospital", Order = 61)]
        public bool IsCommunityHospital { get; set; }

        [XmlElementAttribute("IsFee", Order = 62)]
        [DataMember(EmitDefaultValue = false, Name = "IsFee", Order = 62)]
        public bool IsFee { get; set; }

        [XmlElementAttribute("TransferCoordinator", Order = 63)]
        [DataMember(EmitDefaultValue = false, Name = "TransferCoordinator", Order = 63)]
        public string TransferCoordinator { get; set; }

        [XmlElementAttribute("TransferCoordinatorPhone", Order = 64)]
        [DataMember(EmitDefaultValue = false, Name = "TransferCoordinatorPhone", Order = 64)]
        public string TransferCoordinatorPhone { get; set; }

        #endregion
    }
}
