﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;
using System.Collections;

namespace BMS.DataContracts
{
    /// <summary>
    /// Data about a transfer used in filtering BMS operations.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "TransferInfo")]
    [DataContract(Name = "TransferInfo")]
    [KnownType(typeof(Act))]
    [KnownType(typeof(CD))]
    [KnownType(typeof(II))]
    public class TransferInfo : Act
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the facility VISN.
        /// </summary>
        /// <value>
        /// The facility VISN.
        /// </value>
        [XmlElementAttribute("FacilityVISN", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityVISN", Order = 1)]
        public string FacilityVISN { get; set; }

        /// <summary>
        /// Gets or sets the current location.
        /// </summary>
        /// <value>
        /// The current location.
        /// </value>
        [XmlElementAttribute("CurrentLocation", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "CurrentLocation", Order = 2)]
        public string CurrentLocation { get; set; }

        /// <summary>
        /// Gets or sets the transfer contract.
        /// </summary>
        /// <value>
        /// The contract.
        /// </value>
        [XmlElementAttribute("Contract", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "Contract", Order = 3)]
        public CD Contract { get; set; }

        /// <summary>
        /// Gets or sets the patient diagnosis.
        /// </summary>
        /// <value>
        /// The diagnosis.
        /// </value>
        [XmlElementAttribute("Diagnosis", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "Diagnosis", Order = 4)]
        public string Diagnosis { get; set; }

        /// <summary>
        /// Gets or sets the transfer comments.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        [XmlElementAttribute("Comment", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "Comment", Order = 5)]
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the disposition date.
        /// </summary>
        /// <value>
        /// The disposition date.
        /// </value>
        [XmlElementAttribute("DispositionDate", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "DispositionDate", Order = 6)]
        public DateTime? DispositionDate { get; set; }

        /// <summary>
        /// Gets or sets the facility where the patient is transferred.
        /// </summary>
        /// <value>
        /// The admission facility.
        /// </value>
        [XmlElementAttribute("AdmissionFacilityId", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionFacilityId", Order = 7)]
        public II AdmissionFacilityId { get; set; }

        /// <summary>
        /// Gets or sets the facility from where the patient is transfered(EIS place).
        /// </summary>
        /// <value>
        /// The facility.
        /// </value>
        [XmlElementAttribute("FacilityId", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "FacilityId", Order = 8)]
        public II FacilityId { get; set; }

        /// <summary>
        /// Gets or sets the era for this Transfer.
        /// </summary>
        /// <value>
        /// The era.
        /// </value>
        [XmlElementAttribute("Era", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "Era", Order = 9)]
        public CD Era { get; set; }

        /// <summary>
        /// Gets or sets the speciality.
        /// </summary>
        /// <value>
        /// The speciality.
        /// </value>
        [XmlElementAttribute("Speciality", Order = 10)]
        [DataMember(EmitDefaultValue = false, Name = "Speciality", Order = 10)]
        public CD Speciality { get; set; }

        /// <summary>
        /// Gets or sets the location admission date.
        /// </summary>
        /// <value>
        /// The location admission date.
        /// </value>
        [XmlElementAttribute("LocationAdmissionDate", Order = 11)]
        [DataMember(EmitDefaultValue = false, Name = "LocationAdmissionDate", Order = 11)]
        public DateTime? LocationAdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is national wait list.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance is national wait list; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsNationalWaitList", Order = 12)]
        [DataMember(EmitDefaultValue = false, Name = "IsNationalWaitList", Order = 12)]
        public bool IsNationalWaitList { get; set; }

        /// <summary>
        /// Gets or sets the location admission date.
        /// </summary>
        /// <value>
        /// The location admission date.
        /// </value>
        [XmlElementAttribute("ReqCreateDateTime", Order = 13)]
        [DataMember(EmitDefaultValue = false, Name = "ReqCreateDateTime", Order = 13)]
        public DateTime? ReqCreateDateTime { get; set; }

        /// <summary>
        /// Gets or sets the type of bed or ward needed by the patient(EVS patient).
        /// </summary>
        /// <value>
        /// The type of bed ward.
        /// </value>
        [XmlElementAttribute("TypeOfBedWard", Order = 14)]
        [DataMember(EmitDefaultValue = false, Name = "TypeOfBedWard", Order = 14)]
        public string TypeOfBedWard { get; set; }

        [XmlElementAttribute("IsFee", Order = 15)]
        [DataMember(EmitDefaultValue = false, Name = "IsFee", Order = 15)]
        public bool IsFee { get; set; }

        [XmlElementAttribute("TransferCoordinator", Order = 16)]
        [DataMember(EmitDefaultValue = false, Name = "TransferCoordinator", Order = 16)]
        public string TransferCoordinator { get; set; }

        [XmlElementAttribute("TransferCoordinatorPhone", Order = 17)]
        [DataMember(EmitDefaultValue = false, Name = "TransferCoordinatorPhone", Order = 17)]
        public string TransferCoordinatorPhone { get; set; }

        #endregion
    }
}
