﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    [Serializable]
    [XmlType(TypeName = "MovementWithoutBed")]
    [DataContract(Name = "MovementWithoutBed")]    
    [KnownType(typeof(II))]    
    public class MovementWithoutBed
    {
        /// <summary>
        /// Gets or sets the movement id.
        /// </summary>
        /// <value>
        /// The movement id.
        /// </value>
        [XmlElementAttribute("MovementId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "MovementId", Order = 1)]
        public II MovementId { get; set; }

        /// <summary>
        /// Gets or sets the movement ien.
        /// </summary>
        /// <value>
        /// The movement ien.
        /// </value>
        [XmlElementAttribute("MovementIen", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "MovementIen", Order = 2)]
        public string MovementIen { get; set; }

        /// <summary>
        /// Gets or sets the ward id.
        /// </summary>
        /// <value>
        /// The ward id.
        /// </value>
        [XmlElementAttribute("WardId", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "WardId", Order = 3)]
        public II WardId { get; set; }

        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        /// <value>
        /// The bed id.
        /// </value>
        [XmlElementAttribute("BedId", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "BedId", Order = 4)]
        public II BedId { get; set; }
    }
}
