﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about discharge appointments managed by BMS.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "DischargeAppointment")]
    [DataContract(Name = "DischargeAppointment")]    
    [KnownType(typeof(II))]
    public class DischargeAppointment
    {
        /// <summary>
        /// Gets or sets the id. Identity number and primary key of the table.
        /// </summary>
        /// <value>
        /// The id.
        /// </value>
        [XmlElementAttribute("Id", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "Id", Order = 1)]
        public II Id { get; set; }

        /// <summary>
        /// Gets or sets the patient id on which the appointment is made.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        [XmlElementAttribute("PatientId", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "PatientId", Order = 2)]
        public II PatientId { get; set; }

        /// <summary>
        /// Gets or sets the entered date.
        /// </summary>
        /// <value>
        /// The entered date.
        /// </value>
        [XmlElementAttribute("EnteredDate", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "EnteredDate", Order = 3)]
        public DateTime EnteredDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether the appointment is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if the appointment is active; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("IsActive", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "IsActive", Order = 4)]
        public bool IsActive { get; set; }

        /// <summary>
        /// Gets or sets the date for a discharge appointment.
        /// </summary>
        /// <value>
        /// The appointment date.
        /// </value>
        [XmlElementAttribute("AppointmentDate", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "AppointmentDate", Order = 5)]
        public DateTime? AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the vista site id where the appointment was created.
        /// </summary>
        /// <value>
        /// The vista site id.
        /// </value>
        [XmlElementAttribute("VistaSiteId", Order = 6)]
        [DataMember(EmitDefaultValue = false, Name = "VistaSiteId", Order = 6)]
        public II VistaSiteId { get; set; }

        /// <summary>
        /// Gets or sets the hospital location id where the appointment was created.
        /// </summary>
        /// <value>
        /// The hospital location id.
        /// </value>
        [XmlElementAttribute("HospitalLocationId", Order = 7)]
        [DataMember(EmitDefaultValue = false, Name = "HospitalLocationId", Order = 7)]
        public II HospitalLocationId { get; set; }

        /// <summary>
        /// Gets or sets the ward id where the appointment was created.
        /// </summary>
        /// <value>
        /// The ward id.
        /// </value>
        [XmlElementAttribute("WardId", Order = 8)]
        [DataMember(EmitDefaultValue = false, Name = "WardId", Order = 8)]
        public II WardId { get; set; }

        /// <summary>
        /// Gets or sets the status of the discharge appointment.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        [XmlElementAttribute("Status", Order = 9)]
        [DataMember(EmitDefaultValue = false, Name = "Status", Order = 9)]
        public string Status { get; set; }
    }
}
