﻿using BMS.MT;
using System;
using BMS.Utils;
using System.Collections.Generic;
using BMS.DataContracts;
using System.Linq;
using System.ServiceModel;

namespace BMS.Translators
{
    public static class TranslatorScheduledAdmission
    {
        public static void CopyTo(this ScheduledAdmissionBO scheduledAdmissionBO, DataContracts.ScheduledAdmission scheduledAdmission)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                scheduledAdmission.Id = TranslatorUtils.BuildIdentifier(scheduledAdmissionBO.DOMAIN_ID, scheduledAdmissionBO.ID);
                scheduledAdmission.PatientId = TranslatorUtils.BuildIdentifier(scheduledAdmissionBO.DOMAIN_ID, scheduledAdmissionBO.PATIENT_UID);
                scheduledAdmission.IEN = scheduledAdmissionBO.IEN.Value;
                scheduledAdmission.CanceledDate = scheduledAdmissionBO.CANCELED_DATE.Value;
                scheduledAdmission.ReservationDate = scheduledAdmissionBO.RESERVATION_DATE.Value;
                scheduledAdmission.SchedulerId = TranslatorUtils.BuildIdentifier(scheduledAdmissionBO.DOMAIN_ID, scheduledAdmissionBO.SCHEDULER_UID);
                scheduledAdmission.ProviderId = TranslatorUtils.BuildIdentifier(scheduledAdmissionBO.DOMAIN_ID, scheduledAdmissionBO.PROVIDER_UID);
                scheduledAdmission.VistaSiteId = TranslatorUtils.BuildIdentifier(scheduledAdmissionBO.DOMAIN_ID, scheduledAdmissionBO.VISTA_SITE_UID);
                scheduledAdmission.WardId = TranslatorUtils.BuildIdentifier(scheduledAdmissionBO.DOMAIN_ID, scheduledAdmissionBO.WARD_UID);
                scheduledAdmission.Speciality = TranslatorUtils.BuildConcept(scheduledAdmissionBO.SPECIALITY_CODE, scheduledAdmissionBO.SPECIALITY_CODE_SYSTEM, scheduledAdmissionBO.SPECIALITY_CODE_SYSTEM_NAME, scheduledAdmissionBO.SPECIALITY_DISPLAY_NAME);
                scheduledAdmission.Diagnosis = scheduledAdmissionBO.DIAGNOSIS.Value;
                if (scheduledAdmissionBO.SURGERY.Value.HasValue)
                    scheduledAdmission.Surgery = scheduledAdmissionBO.SURGERY.Value.Value;
                scheduledAdmission.LOSExpected = (scheduledAdmissionBO.LENGTH_OF_STAY_EXPECTED.Value.HasValue) ? scheduledAdmissionBO.LENGTH_OF_STAY_EXPECTED.Value.Value : 0;
                scheduledAdmission.VistaDivision = TranslatorUtils.BuildConcept(scheduledAdmissionBO.VISTA_DIVISION_CODE, scheduledAdmissionBO.VISTA_DIVISION_CODE_SYSTEM, scheduledAdmissionBO.VISTA_DIVISION_CODE_SYSTEM_NAME, scheduledAdmissionBO.VISTA_DIVISION_DISPLAY_NAME);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.ScheduledAdmission scheduledAdmission, ScheduledAdmissionBO scheduledAdmissionBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (scheduledAdmission.Id != null)
                {
                    scheduledAdmissionBO.DOMAIN_ID.Value = scheduledAdmission.Id.root;
                    int? actId = scheduledAdmission.Id.extension.ParseAsInt();
                    if (actId.HasValue)
                        scheduledAdmissionBO.ID.Value = actId.Value;
                }
                if (scheduledAdmission.PatientId != null)                
                    scheduledAdmissionBO.PATIENT_UID.Value = Guid.Parse(scheduledAdmission.PatientId.extension);
                    
                scheduledAdmissionBO.IEN.Value = scheduledAdmission.IEN;
                scheduledAdmissionBO.CANCELED_DATE.Value = scheduledAdmission.CanceledDate;
                scheduledAdmissionBO.RESERVATION_DATE.Value = scheduledAdmission.ReservationDate;
                if (scheduledAdmission.SchedulerId != null)                    
                    scheduledAdmissionBO.SCHEDULER_UID.Value = System.Guid.Parse(scheduledAdmission.SchedulerId.extension);                        
                if (scheduledAdmission.ProviderId != null)                
                    scheduledAdmissionBO.PROVIDER_UID.Value = Guid.Parse(scheduledAdmission.ProviderId.extension);                        
                if (scheduledAdmission.VistaSiteId != null)
                    scheduledAdmissionBO.VISTA_SITE_UID.Value = Guid.Parse(scheduledAdmission.VistaSiteId.extension);                
                if (scheduledAdmission.WardId != null)
                    scheduledAdmissionBO.WARD_UID.Value = Guid.Parse(scheduledAdmission.WardId.extension);                
                if (scheduledAdmission.Speciality != null)
                {
                    scheduledAdmissionBO.SPECIALITY_CODE.Value = scheduledAdmission.Speciality.code;
                    scheduledAdmissionBO.SPECIALITY_CODE_SYSTEM.Value = scheduledAdmission.Speciality.codeSystem;
                    scheduledAdmissionBO.SPECIALITY_CODE_SYSTEM_NAME.Value = scheduledAdmission.Speciality.codeSystemName;
                    scheduledAdmissionBO.SPECIALITY_DISPLAY_NAME.Value = scheduledAdmission.Speciality.displayName;
                }
                scheduledAdmissionBO.DIAGNOSIS.Value = scheduledAdmission.Diagnosis;
                scheduledAdmissionBO.SURGERY.Value = scheduledAdmission.Surgery;
                scheduledAdmissionBO.LENGTH_OF_STAY_EXPECTED.Value = scheduledAdmission.LOSExpected;
                if (scheduledAdmission.VistaDivision != null)
                {
                    scheduledAdmissionBO.VISTA_DIVISION_CODE.Value = scheduledAdmission.VistaDivision.code;
                    scheduledAdmissionBO.VISTA_DIVISION_CODE_SYSTEM.Value = scheduledAdmission.VistaDivision.codeSystem;
                    scheduledAdmissionBO.VISTA_DIVISION_CODE_SYSTEM_NAME.Value = scheduledAdmission.VistaDivision.codeSystemName;
                    scheduledAdmissionBO.VISTA_DIVISION_DISPLAY_NAME.Value = scheduledAdmission.VistaDivision.displayName;
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
