﻿using BMS.MT;
using System;
using System.Linq;
using BMS.Utils;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorDischargeEvent
    {
        public static void CopyTo(this DischargeEvnBO dischargeEventBO, DataContracts.DischargeEvent dischargeEvent)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                dischargeEvent.BedId = TranslatorUtils.BuildIdentifier(dischargeEventBO.DOMAIN_ID, dischargeEventBO.BED_UID);
                dischargeEvent.DischargedDate = dischargeEventBO.DISCHARGED_DATE.Value;
                dischargeEvent.EnteredById = TranslatorUtils.BuildIdentifier(dischargeEventBO.DOMAIN_ID, dischargeEventBO.ENTERED_BY_UID);
                dischargeEvent.EnteredDate = dischargeEventBO.ENTERED_DATE.Value;
                dischargeEvent.Id = TranslatorUtils.BuildIdentifier(dischargeEventBO.DOMAIN_ID, dischargeEventBO.ID);
                dischargeEvent.Ien = dischargeEventBO.IEN.Value;
                dischargeEvent.MovementType = TranslatorUtils.BuildConcept(dischargeEventBO.TYPE_OF_MOVEMENT_CODE, dischargeEventBO.TYPE_OF_MOVEMENT_CODE_SYSTEM, dischargeEventBO.TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME, dischargeEventBO.TYPE_OF_MOVEMENT_DISPLAY_NAME);
                dischargeEvent.PatientId = TranslatorUtils.BuildIdentifier(dischargeEventBO.DOMAIN_ID, dischargeEventBO.PATIENT_UID);
                dischargeEvent.VistaSiteId = TranslatorUtils.BuildIdentifier(dischargeEventBO.DOMAIN_ID, dischargeEventBO.VISTA_SITE_UID);
                dischargeEvent.WardId = TranslatorUtils.BuildIdentifier(dischargeEventBO.DOMAIN_ID, dischargeEventBO.WARD_UID);
                dischargeEvent.AdmissionId = TranslatorUtils.BuildIdentifier(dischargeEventBO.DOMAIN_ID, dischargeEventBO.ADMISSION_ID);
                dischargeEvent.AdmissionIen = dischargeEventBO.ADMISSION_IEN.Value;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.DischargeEvent dischargeEvent, DischargeEvnBO dischargeEventBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (dischargeEvent.BedId != null)
                    dischargeEventBO.BED_UID.Value = Guid.Parse(dischargeEvent.BedId.extension);
                dischargeEventBO.DISCHARGED_DATE.Value = dischargeEvent.DischargedDate;
                if (dischargeEvent.EnteredById != null)
                    dischargeEventBO.ENTERED_BY_UID.Value = Guid.Parse(dischargeEvent.EnteredById.extension);
                dischargeEventBO.ENTERED_DATE.Value = dischargeEvent.EnteredDate;                
                if (dischargeEvent.Id != null)
                {
                    dischargeEventBO.DOMAIN_ID.Value = dischargeEvent.Id.root;
                    int? id = dischargeEvent.Id.extension.ParseAsInt();
                    if (id.HasValue)
                        dischargeEventBO.ID.Value = id.Value;
                }
                dischargeEventBO.IEN.Value = dischargeEvent.Ien;
                if (dischargeEvent.MovementType != null)
                {
                    dischargeEventBO.TYPE_OF_MOVEMENT_CODE.Value = dischargeEvent.MovementType.code;
                    dischargeEventBO.TYPE_OF_MOVEMENT_CODE_SYSTEM.Value = dischargeEvent.MovementType.codeSystem;
                    dischargeEventBO.TYPE_OF_MOVEMENT_CODE_SYSTEM_NAME.Value = dischargeEvent.MovementType.codeSystemName;
                    dischargeEventBO.TYPE_OF_MOVEMENT_DISPLAY_NAME.Value = dischargeEvent.MovementType.displayName;
                }                                
                if (dischargeEvent.PatientId != null)
                    dischargeEventBO.PATIENT_UID.Value = Guid.Parse(dischargeEvent.PatientId.extension);
                if (dischargeEvent.VistaSiteId != null)
                    dischargeEventBO.VISTA_SITE_UID.Value = Guid.Parse(dischargeEvent.VistaSiteId.extension);
                if (dischargeEvent.WardId != null)
                    dischargeEventBO.WARD_UID.Value = Guid.Parse(dischargeEvent.WardId.extension);
                dischargeEventBO.ADMISSION_IEN.Value = dischargeEvent.AdmissionIen;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
