﻿using BMS.MT;
using System;
using System.Linq;
using BMS.Utils;
using System.Collections.Generic;
using ePractice.MiddleTier;
using BMS.DataContracts;

namespace BMS.Translators
{
    public static class TranslatorConfiguration
    {
        public static void CopyTo(this MasterConfigBO masterConfigBO, DataContracts.Configuration config)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<ConfigBO> configBOs = new List<ConfigBO>();
                configBOs.AddRange(masterConfigBO.ConfigList);
                config.UserName = configBOs[0].USER_NAME.Value;
                config.Domain = configBOs[0].DOMAIN_ID.Value;
                config.ConfigType = (ConfigType)Enum.Parse(typeof(ConfigType), configBOs[0].CONFIG_TYPE.Value);

                DataContracts.Element element = null;
                if (config.SectionList == null)
                    config.SectionList = new Dictionary<string, List<Element>>();
                foreach (ConfigBO dbConfig in configBOs)
                {
                    if (!config.SectionList.ContainsKey(dbConfig.SECTION.Value))
                        config.SectionList.Add(dbConfig.SECTION.Value, new List<DataContracts.Element>());

                    element = new DataContracts.Element();
                    dbConfig.CopyTo(element);

                    DataContracts.Element el = config.SectionList[dbConfig.SECTION.Value].Find(a => a.Key == dbConfig.CONFIG_KEY.Value);
                    if (el != null)
                        config.SectionList[dbConfig.SECTION.Value].Remove(el);
                    config.SectionList[dbConfig.SECTION.Value].Add(element);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this MasterConfigBO masterConfigBO, List<DataContracts.Configuration> configList)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                List<ConfigBO> configBOs = new List<ConfigBO>();
                configBOs.AddRange(masterConfigBO.ConfigList);
                DataContracts.Configuration config = null;
                foreach (ConfigBO bo in configBOs)
                {
                    config = configList.Where(a => a.UserName == bo.USER_NAME.Value).FirstOrDefault();
                    if (config == null)
                        config = new DataContracts.Configuration();
                    else
                        configList.Remove(config);

                    config.UserName = bo.USER_NAME.Value;
                    config.Domain = bo.DOMAIN_ID.Value;
                    config.ConfigType = (ConfigType)Enum.Parse(typeof(ConfigType), bo.CONFIG_TYPE.Value);

                    DataContracts.Element element = null;
                    if (config.SectionList == null)
                        config.SectionList = new Dictionary<string, List<Element>>();                    
                        
                    if (!config.SectionList.ContainsKey(bo.SECTION.Value))
                        config.SectionList.Add(bo.SECTION.Value, new List<DataContracts.Element>());

                    element = new DataContracts.Element();
                    bo.CopyTo(element);

                    DataContracts.Element el = config.SectionList[bo.SECTION.Value].Find(a => a.Key == bo.CONFIG_KEY.Value);
                    if (el != null)
                        config.SectionList[bo.SECTION.Value].Remove(el);
                    config.SectionList[bo.SECTION.Value].Add(element);
                    configList.Add(config);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        public static void CopyTo(this DataContracts.Configuration config, ConfigBO configBO)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string sectionKey = config.SectionList.Keys.SingleOrDefault();
                configBO.CONFIG_TYPE.Value = config.ConfigType.ToString();
                configBO.USER_NAME.Value = config.UserName;
                configBO.DOMAIN_ID.Value = config.Domain;
                configBO.SECTION.Value = sectionKey;
                config.SectionList[sectionKey].SingleOrDefault().CopyTo(configBO);
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
