﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;
using BMS.VistaWorker.Reader;
using BMS.VistaWorker.Writer;
using BMS.VistaWorker.Abstract;
using System.Diagnostics;

namespace BMS.VistaWorker.TestConsole
{
    /// <summary>
    /// Main program that test a controller that writes changes to a file.
    /// </summary>
    class Program
    {

        private const string connectionString = @"Data Source=localhost;Initial Catalog=BMS_VISTA_DB;Integrated Security=True";
        private const string WorkerDelayTimeSpan = "0:0:0:1";
        private const string WorkerPeriodTimeSpan = "0:0:0:5";
        private const string WriterFilePath = "writerLog.txt";
        private const int bulkSize = 100;

        /// <summary>
        /// The main method.
        /// </summary>
        /// <param name="args">The args.</param>
        public static void Main(string[] args)
        {
            Trace.Listeners.Add(new TextWriterTraceListener(Console.Out));

            TimeSpan delay = TimeSpan.Parse(WorkerDelayTimeSpan);
            TimeSpan period = TimeSpan.Parse(WorkerPeriodTimeSpan);
            String vistaConnectionString = connectionString;

            IReaderManager readerManager = ReaderManagerFactory.MakeReaderManagerWithTimer(vistaConnectionString,bulkSize, delay, period);
            //  IWriterManager writerManager = WriterManagerFactory.MakeWriterManager(WriterFilePath,true);
            IWriterManager writerManager = WriterManagerFactory.MakeWriterManager();
            using (IController workerController = new Controller(readerManager, writerManager))
            {
                Console.WriteLine("Starting...");
                workerController.Start();
                Console.WriteLine("Press any key to stop...");
                Console.ReadKey(true);
                Console.WriteLine("Stopping...");
            }

            
           
        }

     

 

   



      
    }
}
