﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel.Dispatcher;
using System.ServiceModel.Channels;
using System.Web;
using BMS.Utils;

namespace BMS.Security
{
    public class HttpSessionMessageInspector : IClientMessageInspector
    {
        public void AfterReceiveReply(ref System.ServiceModel.Channels.Message reply, object correlationState) { }

        public object BeforeSendRequest(ref System.ServiceModel.Channels.Message request, System.ServiceModel.IClientChannel channel)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                String sessionIDToSend = ProxyManager.GetCurrentSessionID2();
                if (String.IsNullOrEmpty(sessionIDToSend))
                    return null;

                HttpRequestMessageProperty httpRequestMessage;
                object httpRequestMessageObject = null;
                if (request.Properties.TryGetValue(HttpRequestMessageProperty.Name, out httpRequestMessageObject))
                {
                    httpRequestMessage = httpRequestMessageObject as HttpRequestMessageProperty;
                    if (httpRequestMessage != null && string.IsNullOrEmpty(httpRequestMessage.Headers[Constants.HTTP_SESSION_ID_HTTP_HEADER]))
                        httpRequestMessage.Headers[Constants.HTTP_SESSION_ID_HTTP_HEADER] = sessionIDToSend;
                }
                else
                {
                    httpRequestMessage = new HttpRequestMessageProperty();
                    httpRequestMessage.Headers.Add(Constants.HTTP_SESSION_ID_HTTP_HEADER, sessionIDToSend);
                    request.Properties.Add(HttpRequestMessageProperty.Name, httpRequestMessage);
                }
                return sessionIDToSend;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
