﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Security.DurableIssuedToken
{
    /// <summary>
    /// Factory that returns an IssuedTokenCache implementation.
    /// </summary>
    public static class PersistenceIssuedTokenCacheFactory
    {
        private static IssuedTokenCacheBase _cacheInstance = null;

        /// <summary>
        /// Gets the current IssuedTokenCache implementation.
        /// </summary>
        /// <returns>IssuedTokenCache</returns>
        public static IssuedTokenCache GetIssuedTokenCache()
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (_cacheInstance == null)
                    throw new Exception("IssuedTokenCache was not built yet.");
                return _cacheInstance;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        /// <summary>
        /// Gets the current IssuedTokenCache implementation.
        /// </summary>
        /// <param name="durableIssuedTokenConfiguration">Configuration to use when building the instance.</param>
        /// <returns>IssuedTokenCache</returns>
        public static IssuedTokenCache GetIssuedTokenCache(Configuration.DurableIssuedTokenConfigHandler durableIssuedTokenConfiguration)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                if (_cacheInstance == null)
                {
                    _cacheInstance = new DatabaseIssuedTokenCache(durableIssuedTokenConfiguration);

                    //for FileIssuedTokenCache use the below example
                    //durableIssuedTokenConfiguration.ConnectionString = "d:\\cache.xml";
                    //_cacheInstance = new FileIssuedTokenCache(durableIssuedTokenConfiguration);
                }
                return _cacheInstance;
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}
