﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;
using System.Xml;
using System.IdentityModel.Tokens;
using BMS.Security.Configuration;

namespace BMS.Security.DurableIssuedToken
{
    // A simple file-based durable cache for caching issued tokens at a wider scope than the channel 
    // and that can survive app recycles.
    // The file needs to be ACL'd strongly so as not to reveal the issued token key.
    // A real cache implementation will have quotas, eviction policies etc.
    public class FileIssuedTokenCache : IssuedTokenCacheBase
    {
        public FileIssuedTokenCache(IDurableIssuedTokenConfiguration configuration)
            : base(configuration)
        {
        }

        protected override void AddToken(IssuedTokenCacheBase.Key key, GenericXmlSecurityToken token)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                using (FileStream str = File.Open(Configuration.ConnectionString, FileMode.Append, FileAccess.Write))
                {
                    str.Seek(0, SeekOrigin.End);
                    SerializeCachedToken(str, key.SessionId, token);
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        protected override bool TryGetToken(IssuedTokenCacheBase.Key key, out GenericXmlSecurityToken cachedToken)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                using (FileStream str = File.Open(Configuration.ConnectionString, FileMode.OpenOrCreate, FileAccess.Read))
                {
                    str.Seek(0, SeekOrigin.Begin);
                    return DeserializeCachedToken(str, key, out cachedToken);
                }

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
        protected override void RemoveToken(IssuedTokenCacheBase.Key key)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                using (FileStream str = File.Open(Configuration.ConnectionString, FileMode.Create, FileAccess.Write))
                {
                }
            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }

        protected override string TryGetUserSidFromToken(IssuedTokenCacheBase.Key key)
        {
            DateTime entryInLogMethodTime = DateTime.UtcNow;
            if (InfoWorld.Tracing.IWTrace.IsEntryEnabled)
            {
                InfoWorld.Tracing.IWTrace.Entry(System.Reflection.MethodBase.GetCurrentMethod(), entryInLogMethodTime);
            }
            try
            {
                string result = null;
                using (FileStream str = File.Open(Configuration.ConnectionString, FileMode.OpenOrCreate, FileAccess.Read))
                {
                    str.Seek(0, SeekOrigin.Begin);

                    XmlReaderSettings settings = new XmlReaderSettings();
                    settings.DtdProcessing = DtdProcessing.Prohibit;
                    settings.XmlResolver = null;
                    XmlReader reader = XmlReader.Create(str, settings);
                    //System.Xml.XmlTextReader reader = new System.Xml.XmlTextReader(str);
                    try
                    {
                        while (reader.Read())
                        {
                            if (reader.Name.Equals("Attribute") && reader.HasAttributes)
                            {
                                if (reader.GetAttribute("Name").Equals("UserSID"))
                                {
                                    result = reader.ReadElementString();
                                    break;
                                }
                            }
                        }
                    }
                    catch (System.Xml.XmlException)
                    {
                        result = null;
                    }
                    finally { reader.Close(); }
                    return result;
                }

            }
            finally
            {
                if (InfoWorld.Tracing.IWTrace.IsExitEnabled)
                {
                    InfoWorld.Tracing.IWTrace.Exit(System.Reflection.MethodBase.GetCurrentMethod(), DateTime.UtcNow, entryInLogMethodTime);
                }
            }
        }
    }
}

