using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using BMS.Facade.Data;

namespace BMS.Facade.Implementation
{
    /// <summary>
    /// ReportInfo class
    /// </summary>
    public class ReportInfo : IReportInfo
    {
        private string _fullUserName;
        public ReportInfo(string fullUserName) { _fullUserName = fullUserName; }

        /// <summary>
        /// The name of the report.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// The relative path of the report in Report Server.
        /// </summary>
        public string Path { get; set; }

        /// <summary>
        /// The Url used to access this report.
        /// </summary>
        public string Url
        {
            get
            {
                ReportUtil reportUtil = ReportUtil.CreateDefaultInstance(_fullUserName);
                reportUtil.ReportName = this.Name;
                reportUtil.ReportPath = this.Path;
                reportUtil.Parameters.Clear();
                if (this.Parameters != null)
                    foreach (KeyValuePair<String, String> kvp in this.Parameters)
                        reportUtil.Parameters.Add(kvp.Key, kvp.Value);
                
                string param = ReportUtil.Encrypt(reportUtil);
                param = System.Web.HttpUtility.UrlEncode(param);
                param = "?" + param;

                if (this.Name.Equals(Constants.EMERGENCY_MANAGEMENT_REPORT))
                    return "/Reporting/EvacuationPatientReportViewer.aspx" + param;
                else if (this.Name.Equals(Constants.VISN_EMERGENCY_MGMT_RPT))
                    return "/Reporting/EvacuationPatientVISNReportViewer.aspx" + param;
                else
                    return "/Reporting/ReportViewer.aspx" + param;
            }
        }

        public Dictionary<string, string> Parameters { get; set; }

        public IReportInfo Clone()
        {
            return new ReportInfo(_fullUserName)
            {
                Name = this.Name,
                Path = this.Path,
                Parameters = this.Parameters == null ?
                null : new Dictionary<string, string>(this.Parameters)
            };
        }

    }
}
