﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Facility class. Stores information about facility.
    /// </summary>
    [DataContract]
    public class Facility : Place 
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [DataMember]
        [ConvertDateTime]
        public VistaSite VistaSite { get; set; }

        /// <summary>
        /// Gets or sets the code.
        /// </summary>
        /// <value>
        /// The code.
        /// </value>
        [DataMember]
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is active; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsActive { get; set; }

        /// <summary>
        /// Gets or sets the telephone.
        /// </summary>
        /// <value>
        /// The telephone.
        /// </value>
        [DataMember]
        public string Telephone { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether BMS Active/Live site option from administration section is live or not.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is alive; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsAlive { get; set; }

        /// <summary>
        /// Gets or sets the site number.
        /// </summary>
        /// <value>
        /// The site number.
        /// </value>
        [DataMember]
        public string SiteNumber { get; set; }

        #endregion
    }
}