﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using System.ComponentModel;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Event Notification class - stores all the configuration data about the Event Notifications.
    /// </summary>
    public class EventNotification
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the ward group.
        /// </summary>
        /// <value>
        /// The ward group.
        /// </value>
        public string WardGroup { get; set; }

        /// <summary>
        /// Gets or sets the event name.
        /// </summary>
        /// <value>
        /// The event name.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// DO NOT USE THIS PROPERTY. USE THE BedControllerNotification PROPERTY INSTEAD!!!
        /// </summary>
        /// <value>
        /// The bed controller notify.
        /// </value>
        public string BedControllerNotify { get; set; }

        /// <summary>
        /// Gets or sets whether the bed controller should be notifed.
        /// </summary>
        /// <value>
        /// The bed controller notification.
        /// </value>
        public CD BedControllerNotification { get; set; }

        /// <summary>
        /// DO NOT USE THIS PROPERTY. USE THE OtherNotification PROPERTY INSTEAD!!!
        /// </summary>
        /// <value>
        /// The other notify.
        /// </value>
        public string OtherNotify { get; set; }

        /// <summary>
        /// Gets or sets whether others should be notifed.
        /// </summary>
        /// <value>
        /// The other notification.
        /// </value>
        //public CD OtherNotification { get; set; }

        /// <summary>
        /// Gets or sets the bed controller email address.
        /// </summary>
        /// <value>
        /// The bed controller email address.
        /// </value>
        public string BedControllerEmailAddress { get; set; }

        /// <summary>
        /// Gets or sets the other email address.
        /// </summary>
        /// <value>
        /// The other email address.
        /// </value>
        //public string OtherEmailAddress { get; set; }

        #endregion
    }
}
