﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using InfoWorld.EVS.CTSMAPI;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Bed Clean Info class.
    /// </summary>
    public class BedCleanInfo
    {
        public II BedCleanId { get; set; }

        public string ManualRequest { get; set; }

        public Bed Bed { get; set; }

        public Ward Ward { get; set; }

        public string WardName { get; set; }

        public DateTime? VacatedDate { get; set; }

        public string DisplayVacatedDate
        {
            get
            {
                if (VacatedDate.HasValue)
                    return VacatedDate.Value.ToString("MM/dd/yy HH:mm");
                else
                    return string.Empty;
            }
        }

        public DateTime? RequestedDate { get; set; }

        public string DisplayRequestedDate
        {
            get
            {
                if (RequestedDate.HasValue)
                    return RequestedDate.Value.ToString("MM/dd/yy HH:mm");
                else
                    return string.Empty;
            }
        }

        //Difference between Requested Date and Vacated Date
        public string DiffRequestedDateVacatedDate
        {
            get
            {
                if (VacatedDate != null && RequestedDate != null)
                {
                    int minutes;
                    TimeSpan Duration = RequestedDate.Value.Subtract(VacatedDate.Value);
                    if (Duration.Seconds > 29)
                        minutes = Math.Abs((int)Duration.Minutes) + 1;
                    else
                        minutes = Math.Abs((int)Duration.Minutes);
                    return string.Format("{0:00}:{1:00}", Math.Abs((int)Duration.TotalHours), minutes);
                }
                else
                    return string.Empty;
            }
        }

        public DateTime? AcceptedDate { get; set; }

        public string DisplayAcceptedDate
        {
            get
            {
                if (AcceptedDate.HasValue)
                    return AcceptedDate.Value.ToString("MM/dd/yy HH:mm");
                else
                    return string.Empty;
            }
        }

        //Difference between RequestedDate and AcceptedDate
        public string DiffRequestedDateAcceptedDate
        {
            get
            {
                if (RequestedDate != null && AcceptedDate != null)
                {
                    int minutes1;
                    TimeSpan Duration1 = RequestedDate.Value.Subtract(AcceptedDate.Value);
                    if (Duration1.Seconds > 29)
                        minutes1 = Math.Abs((int)Duration1.Minutes) + 1;
                    else
                        minutes1 = Math.Abs((int)Duration1.Minutes);
                    return string.Format("{0:00}:{1:00}", Math.Abs((int)Duration1.TotalHours), minutes1);
                }
                else
                    return string.Empty;
            }
        }

        public DateTime? CompletedDate { get; set; }

        public string DisplayCompletedDate
        {
            get
            {
                if (CompletedDate.HasValue)
                    return CompletedDate.Value.ToString("MM/dd/yy HH:mm");
                else
                    return string.Empty;
            }
        }

        //Difference between AcceptedDate and CompletedDate
        public string DiffAcceptedDateCompletedDate
        {
            get
            {
                if (AcceptedDate != null && CompletedDate != null)
                {
                    int minutes2;
                    TimeSpan Duration2 = AcceptedDate.Value.Subtract(CompletedDate.Value);
                    if (Duration2.Seconds > 29)
                        minutes2 = Math.Abs((int)Duration2.Minutes) + 1;
                    else
                        minutes2 = Math.Abs((int)Duration2.Minutes);
                    return string.Format("{0:00}:{1:00}", Math.Abs((int)Duration2.TotalHours), minutes2);
                }
                else
                    return string.Empty;
            }
        }

        public DateTime? LastEditDate { get; set; }

        public string AcceptedBy { get; set; }

        public string CompletedBy { get; set; }

        //Display Last Edit Date
        public string DisplayLastEditDate
        {
            get
            {
                if (LastEditDate.HasValue)
                    return LastEditDate.Value.ToString("MM/dd/yy HH:mm");
                else
                    return string.Empty;
            }
        }

        public string LastEditBy { get; set; }

        public string LastEdited
        {
            get
            {
                return LastEditBy + " - " + DisplayLastEditDate;
            }
        }

        public int Index { get; set; }

        public int TotalCount { get; set; }

        public IconInfo UnavailableType { get; set; }

        /// <summary>
        /// Gets or sets the EMS notify.
        /// </summary>
        /// <value>
        /// The EMS notify.
        /// </value>
        public IconInfo EMSNotify { get; set; }

        public string Comment { get; set; }

        public string CommentedBy { get; set; }

        public DateTime? CommentedDate { get; set; }

        public string DisplayCommentedDate
        {
            get
            {
                if (CommentedDate.HasValue)
                    return CommentedDate.Value.ToString("MM/dd/yy HH:mm");
                else
                    return string.Empty;
            }
        }

        public string Commented 
        {
            get
            { 
                return CommentedBy + " - " + DisplayCommentedDate;
            } 
        }

        /// <summary>
        /// Gets or sets the ien.
        /// </summary>
        /// <value>
        /// The ien.
        /// </value>
        public string Ien { get; set; }
    }
}