﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using InfoWorld.HL7.ITS;
using InfoWorld.EVS.CTSMAPI;
using System.Runtime.Serialization;

namespace BMS.Facade.Data
{
    /// <summary>
    /// Bed Class. Stores information about bed.
    /// </summary>
    [DataContract]
    public class Bed : Place
    {
        #region Public Members

        /// <summary>
        /// Gets or sets the ward.
        /// </summary>
        /// <value>
        /// The ward.
        /// </value>
        [DataMember]
        [ConvertDateTime]
        public List<Ward> WardList { get; set; }

        /// <summary>
        /// Gets or sets the comment list.
        /// </summary>
        /// <value>
        /// The comment list.
        /// </value>
        [DataMember]
        public List<BedComment> CommentList { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        /// <value>
        /// The reason.
        /// </value>
        [DataMember]
        public CD Reason { get; set; }

        /// <summary>
        /// Gets or sets the nurse assignment.
        /// </summary>
        /// <value>
        /// The nurse assignment.
        /// </value>
        [DataMember]
        public string NurseAssignment { get; set; }

        /// <summary>
        /// Gets or sets the bed status.
        /// </summary>
        /// <value>
        /// The bed status.
        /// </value>
        [DataMember]
        public CD BedStatus { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [bed hold].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [bed hold]; otherwise, <c>false</c>.
        /// </value>
        [DataMember]
        public bool IsBedHold { get; set; }

        /// <summary>
        /// Gets or sets the vista site.
        /// </summary>
        /// <value>
        /// The vista site.
        /// </value>
        [DataMember]
        public VistaSite VistaSite { get; set; }

        #endregion
    }
}
