﻿using System;
using System.Runtime.Serialization;
using System.Data.Odbc;
using System.ComponentModel.DataAnnotations;
using System.Collections.Generic;
using BMS.VistaIntegration.FacadeContracts.Admin;

namespace BMS.VistaIntegration.FacadeContracts
{
    [Serializable]
    [DataContract]
    public class VistASite
    {
        public string Id { get; set; }
        public string Number { get; set; }
        public string Name { get; set; }
        public TimeZoneInfo TimeZone { get; set; }
        public string OdbcConnectionString { get; set; }
        public string OdbcUser { get; set; }
        [DataType(DataType.Password)]
        public string OdbcPwd { get; set; }
        public Dictionary<VistaDataType, DataRetrieval> DataRetrievalDetails { get; set; }
        public string MdwsEndpointConfigKey { get; set; }
    }
}
