﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace BMS.Schedulers.DateTimeValidators.TimerValidators
{
    public class OccursEveryMinute : IDateTimeValidator
    {
        public int OccursEvery { get; private set; }
        public TimeSpan StartTime { get; private set; }
        public TimeSpan EndTime { get; private set; }

        public OccursEveryMinute(int occursEvery, TimeSpan startTime, TimeSpan endTime)
        {
                OccursEvery = occursEvery;
                StartTime = startTime;
                EndTime = endTime;
        }

        public void Init(DateTime dateTimeStarted)
        {
           
        }

        private bool IsInInterval(DateTime now)
        {

                return StartTime <= now.TimeOfDay && now.TimeOfDay <= EndTime;

        }

        private bool IsOccured(DateTime now)
        {
                TimeSpan dif = now.TimeOfDay - StartTime;
                int nowTotalMinutes = (int)Math.Round(dif.TotalMinutes, 0);
                bool result = nowTotalMinutes % OccursEvery == 0;
                return result;
        }

        public bool IsValid(DateTime now)
        {
                bool result = IsInInterval(now) && IsOccured(now);
                return result;
        }
    }
}
