﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.QuerySvcService;

namespace Mdws2ORM.RpcQueries.Commands.Util
{
    public static class QuerySvcExtensions
    {

        /// <summary>
        /// Call FIND^DIC to get a list of matches on the file for the input value.
        /// </summary>
        /// <param name="client">The wcf client.</param>
        /// <param name="fileNumber">This is the number of the file in which you wish to search. ( required , maxlength = 20 )</param>
        /// <param name="field">This is an ^ (or ";") delimited list of fields that you wish returned from each entry that matches the lookup conditions that you have specified.  ( required , maxlength = 250 )</param>
        /// <param name="value">Enter a value that will be used by Fileman for the lookup.  This call does not support the .VALUE syntax allowed by FIND^DIC. ( required , maxlength = 100 )</param>
        /// <param name="iens">This is the IENS through which you wish to search for the value VALUE. If you are searching the top level of a file, this should be null.  See the FileMan Programmers manual for instructions on constructing IENS strings. ( optional , maxlength = 30 )</param>
        /// <param name="number">This is the maximum number of entries to be returned.  Defaults to all entries matching the lookup value VALUE. ( optional , maxlength = 5 )</param>
        /// <param name="index">If you wish to do the lookup on specific indexes, then enter that here. The index string must be compliant with the Fileman Documentation.  ( optional , maxlength = 50 )</param>
        /// <param name="screen">If you wish to use the DIC("S") equivalent then enter it here.  ( optional , maxlength = 250 )</param>
        /// <param name="flags">This is the Fileman FLAGS parameter used in the FILE^DIC api.  ( optional , maxlength = 20 )</param>
        /// <returns></returns>
        public static TaggedTextArray FIND_DIC(this QuerySvcSoap client, string fileNumber, string field, string value, string iens = "", string number = "", string index = "", string screen = "", string flags = "")
        {

            return client.runRpc("DSIC DDR FINDER",
                    new string[] { fileNumber, iens, field, number, value, index, screen, flags },
                    new int[] { 1, 1, 1, 1, 1, 1, 1, 1, },
                    new bool[] { false, false, false, false, false, false, false, false, });
        }


        /// <summary>
        /// This calls the Fileman lister, LIST^DIC to get a list of records matching  the input value.
        /// </summary>
        /// <param name="client">The wcf client.</param>
        /// <param name="fileNumber">This is the file number of the file that will be searched. ( required , maxlength = 20 )</param>
        /// <param name="iens">This is the standard Fileman IENS string when doing a search/lookup on a multiple in a file. ( optional , maxlength = 30 )</param>
        /// <param name="field">';' delimited list of fields requested for each record. ( optional , maxlength = 250 )</param>
        /// <param name="flags">This is the FLAGS parameter for the LIST^DIC api. ( optional , maxlength = 15 )</param>
        /// <param name="number">Enter the maximum number of matching records you wish to retrieve. ( optional , maxlength = 4 )</param>
        /// <param name="from">Enter the string that will be the starting value to use when transversing the indexes looking for a match. ( optional , maxlength = 50 )</param>
        /// <param name="partial">This is the PARTIAL parameter in the LIST^DIC call. ( optional , maxlength = 50 )</param>
        /// <param name="index">Enter the string of index names (separated by '^') which the search will transverse. ( optional , maxlength = 50 )</param>
        /// <param name="screen">If you wish to screen entries, then enter that executable M code.  This is the same as DIC("S") ( optional , maxlength = 250 )</param>
        /// <param name="identify"> This is the IDENTIFIER parameter in LIST^DIC call. ( optional , maxlength = 50 )</param>
        /// <returns></returns>
        public static TaggedTextArray LIST_DIC(this QuerySvcSoap client, string fileNumber, string iens = "", string field = "", string flags = "", string number = "", string from = "", string partial = "", string index = "", string screen = "", string identify = "")
        {

            return client.runRpc("DSIC DDR LISTER",
                   new string[] { fileNumber, iens, field, flags, number, from, partial, index, screen, identify },
                   new int[] { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1 },
                   new bool[] { false, false, false, false, false, false, false, false, false, false, });

        }


        /// <summary>
        /// This calls GETS^DIQ to get a list of field values for a record
        /// </summary>
        /// <param name="client">The wcf client.</param>
        /// <param name="fileNumber">This is the number of the file in which you wish to search. ( required , maxlength = 20 ).</param>
        /// <param name="iens">This is the IENS for the search.  See the instructions on constructing an IENS in the FileMan Programmer's Manual. ( required , maxlength = 20 )</param>
        /// <param name="field">This is an ^ (or ";") delimited list of field numbers to return from the entry identified in IENS. ( required , maxlength = 250 ) </param>
        /// <param name="flags"> This is a string containing up to 3 characters that will modify how
        ///  FileMan presents the results of this operation:
        ///
        ///         E: Return data in external format
        ///         I: Return data in internal format
        ///
        ///         N: Do NOT return null values - not to be used by DSS GUI
        ///         R: Resolves field numbers to field names
        ///         W: Input field is a word processing field
        ///
        ///  If the W flag is passed, then this call expects that the Field parameter
        ///  will have a single field number only.  The W flag must be sent by
        ///  itself.  It cannot be combined with other flags.  W introduced 12/9/2003. ( required , maxlength = 20 )</param>
        /// <returns></returns>
        public static TaggedTextArray GETS_DIQ(this QuerySvcSoap client, string fileNumber, string iens, string field, string flags = "")
        {

            return client.runRpc("DSIC DDR GETS ENTRY DATA",
                 new string[] { fileNumber, iens, field, flags },
                 new int[] { 1, 1, 1, 1, },
                 new bool[] { false, false, false, false });

        }
    }
}
