﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.Core;

namespace Mdws2ORM.Maps.BaseFields
{
    public abstract class BaseMultipleFieldMap<T> where T : class
    {
        protected BaseMultipleFieldMap(string field)
        {
            Field = field;
            FetchParam = ListParamBuilder.DefaultParam;
            IsFetchEnabled = true;
        }

        public string Field { get; private set; }
        public ListParam FetchParam { get; set; }
        public bool IsFetchEnabled { get; set; }
        public abstract void Map(IEntityQuery query, T parent, string iens);
        public virtual void Init(InitMapMediator initMediator) { }
    }
}
