﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Mdws2ORM.QuerySvcService;
using Mdws2ORM.Core;
using Mdws2ORM.Exceptions;
using BMS.Utils;
using BMS.VistaIntegration.Data;

namespace Mdws2ORM.DdrQueries.Commands
{
    public static class DdrListerCommand
    {
        public static IList<Entry> Execute(QuerySvcSoap client, QueryParam queryParam, ListParam listParam, VistASite vistaSite, string iens = "")
        {            
            if (iens.Length > 0 && iens[iens.Length - 1] != ',')
                iens += ",";
            if (queryParam.File.Equals("405.4") && !string.IsNullOrEmpty(listParam.Identity))
            {
                queryParam = new QueryParam(queryParam.File, queryParam.FieldParam.Replace(";100", string.Empty), queryParam.Fields);
                string identity = "S X=\"\" I $D(^DG(405.4,Y,\"W\",0)) S a=\"\" F  S a=$O(^DG(405.4,Y,\"W\",a)) Q:a=\"\"  I a>0 S X=a  D EN^DDIOL(X)";
                listParam = new ListParam(listParam.From, listParam.Number, listParam.Screen, listParam.Flags, listParam.Partial, identity, listParam.Index);
            }
            if (queryParam.File.Equals("44.001") && !string.IsNullOrEmpty(listParam.Identity))            
                queryParam = new QueryParam(queryParam.File, queryParam.FieldParam.Replace(";2", string.Empty), queryParam.Fields);                            

            int i = 0;
            TextArray rpcResult = new TextArray();
            while (i < 4)
            {
                i++;
                try
                {
                  rpcResult = client.ddrLister(
                  queryParam.File,
                  iens,
                  queryParam.FieldParam,
                  listParam.Flags,
                  listParam.Number,
                  listParam.From,
                  listParam.Partial,
                  listParam.Index,
                  listParam.Screen,
                  listParam.Identity);

                    //Tracer.TraceMessage(String.Format("\"{0}\",\"{1}\",\"{2}\",\"{3}\",\"{4}\",\"{5}\",\"{6}\",\"{7}\",\"{8}\",\"{9}\"", queryParam.File, iens, queryParam.FieldParam, listParam.Flags, listParam.Number, listParam.From, listParam.Partial, listParam.Index, listParam.Screen, listParam.Identity));
                }
                catch (Exception e)
                {
                    if (i == 4)
                    {
                        Tracer.TraceMessage(vistaSite.Name + " - List Iteration " + i + " exception. File: " + queryParam.File);
                        Tracer.TraceException(e);
                        throw;
                    }
                    else
                    {
                        System.Threading.Thread.Sleep(5000);
                        continue;
                    }
                }
                if (rpcResult.fault == null)
                {
                    if (queryParam.File.Equals("405.4") && !string.IsNullOrEmpty(listParam.Identity))
                        return ProcessLinesRoomBed(queryParam, rpcResult.text);
                    else if (queryParam.File.Equals("44.001") && !string.IsNullOrEmpty(listParam.Identity))
                        return ProcessLinesClinicAppointment(queryParam, rpcResult.text);
                    else
                        return ProcessLines(queryParam, rpcResult.text);
                }
                else
                {
                    if (i == 4)
                    {
                        Tracer.TraceMessage(vistaSite.Name + " - List Iteration " + i + " Mdws fault. File: " + queryParam.File);
                        QueryFaultException ex = new QueryFaultException(rpcResult.fault);
                        Tracer.TraceException(ex);
                        throw ex;
                    }
                    else
                        Utils.IsAlive(client, vistaSite);
                }
                
            }
            if (queryParam.File.Equals("405.4") && !string.IsNullOrEmpty(listParam.Identity))
                return ProcessLinesRoomBed(queryParam, rpcResult.text);
            else if (queryParam.File.Equals("44.001") && !string.IsNullOrEmpty(listParam.Identity))
                return ProcessLinesClinicAppointment(queryParam, rpcResult.text);
            else
                return ProcessLines(queryParam, rpcResult.text);
        }

        private static IList<Entry> ProcessLines(QueryParam queryParam, string[] lines)
        {
            Entry[] result = new Entry[lines.Length];  
            for (int i = 0; i < lines.Length; i++)
            {
                string[] values = lines[i].Split('^');
                Entry.Field[] fields = new Entry.Field[queryParam.Fields.Length];
                string ien = values[0];
                for (int j = 0; j < values.Length - 1; j++)
                {
                    try
                    {
                        fields[j] = new Entry.Field(queryParam.Fields[j], values[j + 1]);
                    }
                    catch (IndexOutOfRangeException) { }
                }
                result[i] = new Entry(queryParam.File, ien, fields);
            }
            return result;
        }

        private static IList<Entry> ProcessLinesRoomBed(QueryParam queryParam, string[] lines)
        {
            Entry[] result = new Entry[lines.Length];
            for (int i = 0; i < lines.Length; i++)
            {
                string[] values = lines[i].Split('^');
                if (values != null && values.Length == 4)
                {
                    Entry.Field[] fields = new Entry.Field[queryParam.Fields.Length];
                    string ien = values[0];

                    fields[0] = new Entry.Field(queryParam.Fields[0], values[1]);
                    fields[1] = new Entry.Field(queryParam.Fields[1], values[2]);
                    fields[2] = new Entry.Field(queryParam.Fields[2], string.IsNullOrEmpty(values[3]) ? string.Empty : values[3].Replace('~', ','));

                    result[i] = new Entry(queryParam.File, ien, fields);
                }
            }
            return result;
        }

        private static IList<Entry> ProcessLinesClinicAppointment(QueryParam queryParam, string[] lines)
        {
            Entry[] result = new Entry[lines.Length];
            for (int i = 0; i < lines.Length; i++)
            {
                string[] values = lines[i].Split('^');
                if (values != null && values.Length == 3)
                {
                    Entry.Field[] fields = new Entry.Field[queryParam.Fields.Length];
                    string ien = values[0];

                    fields[0] = new Entry.Field(queryParam.Fields[0], values[1]);                    
                    fields[1] = new Entry.Field(queryParam.Fields[1], string.IsNullOrEmpty(values[2]) ? string.Empty : values[2].Replace('~', ','));

                    result[i] = new Entry(queryParam.File, ien, fields);
                }
            }
            return result;
        }
    }
}
