USE BMS

BEGIN TRAN

-- EIS ORGANIZATION
INSERT INTO EIS_ENTITY (EIS_UID)
SELECT IDENTIFIER FROM BMS_EIS.dbo.ENTITY E
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION
	
INSERT INTO EIS_ORGANIZATION (ID, NAME)
SELECT EE.ID, O.NAME
FROM EIS_ENTITY AS EE
	INNER JOIN BMS_EIS.dbo.ENTITY AS E ON E.IDENTIFIER = EE.EIS_UID
	INNER JOIN BMS_EIS.dbo.EHL7_ORGANIZATION AS O ON E.PK_ENTITY = O.PFK_ORGANIZATION

-- EIS PLACE
INSERT INTO EIS_ENTITY (EIS_UID)
SELECT IDENTIFIER FROM BMS_EIS.dbo.ENTITY E
	INNER JOIN BMS_EIS.dbo.EHL7_PLACE P ON E.PK_ENTITY = P.PFK_PLACE
	
INSERT INTO EIS_PLACE (ID, NAME)
SELECT EE.ID, P.NAME
FROM EIS_ENTITY EE
	INNER JOIN BMS_EIS.dbo.ENTITY E ON E.IDENTIFIER = EE.EIS_UID
	INNER JOIN BMS_EIS.dbo.EHL7_PLACE P ON E.PK_ENTITY = P.PFK_PLACE

EXEC dbo.usp_Insert_Concept @ID=-1, @CODE='M', @CODE_SYSTEM=N'2.16.840.1.113883.5.1', @CODE_SYSTEM_NAME=N'Gender', @DISPLAY_NAME=N'Male'
EXEC dbo.usp_Insert_Concept @ID=-1, @CODE='F', @CODE_SYSTEM=N'2.16.840.1.113883.5.1', @CODE_SYSTEM_NAME=N'Gender', @DISPLAY_NAME='Female'

-- EIS PERSON
INSERT INTO EIS_ENTITY (EIS_UID)
SELECT IDENTIFIER FROM BMS_EIS.dbo.ENTITY E
	INNER JOIN BMS_EIS.dbo.EHL7_PERSON P ON E.PK_ENTITY = P.PFK_PERSON
	
INSERT INTO EIS_PERSON (ID, GENDER_ID, SSN, LAST_NAME, FIRST_NAME, MIDDLE_INITIAL)
SELECT EE.ID, C.ID, EU.IDENTIFIER_EXTENSION, P.NAME_FAMILY, P.NAME_FIRST_GIVEN, P.NAME_SECOND_GIVEN
FROM EIS_ENTITY EE
	INNER JOIN BMS_EIS.dbo.ENTITY E ON E.IDENTIFIER = EE.EIS_UID
	INNER JOIN BMS_EIS.dbo.EHL7_PERSON P ON E.PK_ENTITY = P.PFK_PERSON
	INNER JOIN CONCEPT C ON C.CODE = P.ADMINISTRATIVE_GENDER_CODE AND C.CODE_SYSTEM = P.ADMINISTRATIVE_GENDER_CODE_SYSTEM
	INNER JOIN BMS_EIS.dbo.EHL7_UID EU ON P.PFK_PERSON = EU.FK_ENTITY AND EU.IDENTIFIER_ROOT = 'SSN'

COMMIT TRAN
-- ROLLBACK TRAN

