USE [BMS_DW]
GO

/****** Object:  StoredProcedure [dbo].[usp_Rpt_ScheduledAdmissionsByDate]    Script Date: 07/28/2015 14:51:50 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO


-- ============================================= 
-- Change History
-- Date		Author	Description
-- 6/26/15	AKR		Modified to display patient name as LASTNAME (FirstInitial-LastName + LastFour-SSN)
-- =============================================


ALTER PROCEDURE [dbo].[usp_Rpt_ScheduledAdmissionsByDate] 
	@START_DATE DATETIME,
	@END_DATE DATETIME,
	@USER_NAME NVARCHAR(100),
	@FACILITY_EXTENSION NVARCHAR(250),
	@TIME_ZONE_MINUTES_OFFSET INT,
	@VISTA_DIVISION_NAME NVARCHAR(250)	
AS
BEGIN
		
	IF @START_DATE > @END_DATE
		RAISERROR ('The start date is greater than the end date. Please correct.', 18, 13)
	ELSE
	BEGIN
	
	DECLARE @SQL_SELECT NVARCHAR(4000), @SQL_WHERE NVARCHAR(4000), @SQL NVARCHAR(4000)
	
	set @START_DATE = DATEADD (minute, -@TIME_ZONE_MINUTES_OFFSET, @START_DATE);
	set @END_DATE = DATEADD (minute, -@TIME_ZONE_MINUTES_OFFSET, @END_DATE);
	
	-- create permission table
	CREATE TABLE #PERMISSION
    (
     DIM_ORGANIZATION_ID INT,
     DIM_WARD_ID INT
    )
    --insert permission for the user
    INSERT INTO #PERMISSION 
		SELECT * FROM dbo.ufn_GetPermissionByUserName(@USER_NAME)
			CREATE NONCLUSTERED INDEX [DIM_ORGANIZATION_ID] ON #PERMISSION ([DIM_ORGANIZATION_ID] ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON)
			CREATE NONCLUSTERED INDEX DIM_WARD_ID ON #PERMISSION (DIM_WARD_ID ASC)
				WITH (
					 PAD_INDEX  = OFF,
					 STATISTICS_NORECOMPUTE  = OFF,
					 SORT_IN_TEMPDB = OFF,
					 IGNORE_DUP_KEY = OFF,
					 DROP_EXISTING = OFF,
					 ONLINE = OFF,
					 ALLOW_ROW_LOCKS  = ON,
					 ALLOW_PAGE_LOCKS  = ON) ;
	
	
	
	DECLARE @FACILITY_ID INT
	--get facility id
	SET @FACILITY_ID = dbo.ufn_GetFacilityIdByIdentifier(@FACILITY_EXTENSION);
	
	--check if the user has permission for the facility		
	IF EXISTS(SELECT 1 
			  FROM #PERMISSION
			  WHERE DIM_ORGANIZATION_ID = @FACILITY_ID)
		BEGIN
		
				SET @SQL_SELECT = 'SELECT  PATIENT.LAST_NAME + '' ('' + LEFT(PATIENT.LAST_NAME, 1) + RIGHT(PATIENT.SSN, 4)+ '')'' AS PATIENT_NAME,
						''GENDER'' = CASE
									WHEN PATIENT.GENDER = ''M'' THEN ''MALE''
									ELSE ''FEMALE''	
								   END,
						CONVERT(VARCHAR, DATEADD (minute, ' + cast(@TIME_ZONE_MINUTES_OFFSET as varchar(10)) + ' , SCHED_ADMISSION.RESERVATION_DATE), 101) + '' '' +
						CONVERT(varchar(5), DATEADD (minute, ' + cast(@TIME_ZONE_MINUTES_OFFSET as varchar(10)) + ', SCHED_ADMISSION.RESERVATION_DATE), 108) AS RESERVATION_DATE,
						MED_DIV.DISPLAY_NAME AS DIVISION_NAME,
						WARD.NAME AS WARD_NAME,
						SPECIALTY.DISPLAY_NAME AS SPECIALTY,
						SCHED_ADMISSION.DIAGNOSIS AS DIAGNOSIS,
						''SURGERY'' = CASE
										WHEN SCHED_ADMISSION.SURGERY = 1 THEN ''YES''
										ELSE ''NO''
									END,
						SCHED_ADMISSION.LENGTH_OF_STAY_EXPECTED as LOS,
						PROVIDER.FULL_NAME AS PROVIDER,
						SCHEDULER.FULL_NAME AS SCHEDULER,
						SCHED_ADMISSION.CANCELED_DATE AS DT_CANCELLED
						
				FROM FACT_SCHEDULED_ADMISSION SCHED_ADMISSION
				INNER JOIN dbo.DIM_PATIENT AS PATIENT ON PATIENT.ID = SCHED_ADMISSION.DIM_PATIENT_ID
				LEFT JOIN dbo.DIM_WARD AS WARD ON WARD.ID = SCHED_ADMISSION.DIM_WARD_ID
				LEFT JOIN dbo.DIM_TREATING_SPECIALTY AS SPECIALTY ON SPECIALTY.ID = SCHED_ADMISSION.DIM_TREATING_SPECIALTY_ID
				LEFT JOIN dbo.DIM_PHYSICIAN AS PROVIDER ON PROVIDER.ID = SCHED_ADMISSION.PROVIDER_DIM_PHYSICIAN_ID
				LEFT JOIN dbo.DIM_PHYSICIAN AS SCHEDULER ON SCHEDULER.ID = SCHED_ADMISSION.SCHEDULER_DIM_PHYSICIAN_ID
				LEFT JOIN dbo.DIM_MEDICAL_DIVISION AS MED_DIV ON MED_DIV.ID = SCHED_ADMISSION.DIM_MEDICAL_DIVISION_VISTA_DIVISION_ID '
				
				SET @SQL_WHERE = ' WHERE SCHED_ADMISSION.RESERVATION_DATE BETWEEN '''+ convert(varchar(25),@START_DATE,121) + 
						''' AND DATEADD(ms, -3,''' +  convert(varchar(25),@END_DATE + 1,121) + ''')'
				
				IF @VISTA_DIVISION_NAME = ''	
					SET @SQL_WHERE += '	AND SCHED_ADMISSION.VISTA_SITE_DIM_ORGANIZATION_ID = 
										(
											SELECT DIM_ORGANIZATION_ID 
											FROM DIM_ORGANIZATION
											WHERE ID = ''' + cast(@FACILITY_ID as varchar(10))+ ''')'
				ELSE
					SET @SQL_WHERE += ' AND MED_DIV.CODE = ''' + @VISTA_DIVISION_NAME + ''''
				
				SET @SQL = @SQL_SELECT + @SQL_WHERE
				--print(@sql)
				EXECUTE sp_executesql @SQL
					
		END
	--ELSE
	--	BEGIN
	--		SELECT  NULL AS PATIENT_NAME, 
	--				NULL AS GENDER,
	--				NULL AS REZERVATION_DATE,
	--				NULL AS DIVISION_NAME,
	--				NULL AS WARD_NAME,
	--				NULL AS SPECIALTY,
	--				NULL AS DIAGNOSIS,
	--				NULL AS SURGERY,
	--				NULL AS LOS,
	--				NULL AS PROVIDER,
	--				NULL AS SCHEDULER,
	--				NULL AS DT_CANCELLED
	--	END	

	DROP TABLE #PERMISSION		
	
	END --error		
END



GO


