-- Columns

CREATE TABLE [dbo].[WORKFLOW_LOG]
(
[CPRS_ORDERS_ID] [int] NULL,
[PATIENT_APPOINTMENT_ID] [int] NULL,
[PATIENT_MOVEMENT_ID] [int] NULL,
[SCHEDULED_ADMISSION_ID] [int] NULL,
[ID] [int] NOT NULL IDENTITY(1, 1),
[TIMESTAMP] [datetime] NOT NULL CONSTRAINT [DF_WorkflowLog_TIMESTAMP] DEFAULT (getdate())
)
GO
-- Constraints and Indexes

ALTER TABLE [dbo].[WORKFLOW_LOG] ADD CONSTRAINT [PK_WorkflowLog] PRIMARY KEY CLUSTERED  ([ID])
GO
-- Foreign Keys

ALTER TABLE [dbo].[WORKFLOW_LOG] ADD CONSTRAINT [FK_WORKFLOW_LOG_CPRS_ORDERS] FOREIGN KEY ([CPRS_ORDERS_ID]) REFERENCES [dbo].[CPRS_ORDERS] ([IEN])
GO
ALTER TABLE [dbo].[WORKFLOW_LOG] ADD CONSTRAINT [FK_WORKFLOW_LOG_PATIENT_APPOINTMENT] FOREIGN KEY ([PATIENT_APPOINTMENT_ID]) REFERENCES [dbo].[PATIENT_APPOINTMENT] ([IEN])
GO
ALTER TABLE [dbo].[WORKFLOW_LOG] ADD CONSTRAINT [FK_WORKFLOW_LOG_PATIENT_MOVEMENT] FOREIGN KEY ([PATIENT_MOVEMENT_ID]) REFERENCES [dbo].[PATIENT_MOVEMENT] ([IEN])
GO
ALTER TABLE [dbo].[WORKFLOW_LOG] ADD CONSTRAINT [FK_WORKFLOW_LOG_SCHEDULED_ADMISSION] FOREIGN KEY ([SCHEDULED_ADMISSION_ID]) REFERENCES [dbo].[SCHEDULED_ADMISSION] ([IEN])
GO