-- Columns

CREATE TABLE [dbo].[PATIENT_APPOINTMENT]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[APPOINTMENT_DATETIME] [datetime] NOT NULL,
[HOSPITAL_LOCATION_ID] [int] NOT NULL,
[HOSPITAL_LOCATION_TELEPHONE] [nvarchar] (100) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[STATUS] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DATA_ENTRY_CLERK] [nvarchar] (max) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[DATE_APPOINTMENT_MADE] [datetime] NOT NULL,
[CURRENT_STATUS] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PATIENT_ID] [int] NOT NULL,
[INTERNAL_UID] [uniqueidentifier] NULL,
)
GO
-- Triggers


CREATE TRIGGER [dbo].[PATIENT_APPOINTMENT_tgg_insert_update]
   ON  [dbo].[PATIENT_APPOINTMENT]
   AFTER insert,update
AS 
BEGIN	


	INSERT INTO [dbo].[WORKFLOW_LOG] ( PATIENT_APPOINTMENT_ID )

        SELECT IEN
          FROM inserted;
END

GO
-- Constraints and Indexes

ALTER TABLE [dbo].[PATIENT_APPOINTMENT] ADD CONSTRAINT [PK_PATIENT_APPOINTMENT] PRIMARY KEY CLUSTERED  ([IEN])
GO
-- Foreign Keys

ALTER TABLE [dbo].[PATIENT_APPOINTMENT] ADD CONSTRAINT [FK_PATIENT_APPOINTMENT_HOSPITAL_LOCATION] FOREIGN KEY ([HOSPITAL_LOCATION_ID]) REFERENCES [dbo].[HOSPITAL_LOCATION] ([IEN])
GO
ALTER TABLE [dbo].[PATIENT_APPOINTMENT] ADD CONSTRAINT [FK_PATIENT_APPOINTMENT_PATIENT] FOREIGN KEY ([PATIENT_ID]) REFERENCES [dbo].[PATIENT] ([IEN])
GO
-- Extended Properties

EXEC sp_addextendedproperty N'MS_Description', N'Table that contains data regarding patients'' appointments.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_APPOINTMENT', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time of the appointment.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_APPOINTMENT', 'COLUMN', N'APPOINTMENT_DATETIME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Appointment''s current status.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_APPOINTMENT', 'COLUMN', N'CURRENT_STATUS'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Data entry clerk.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_APPOINTMENT', 'COLUMN', N'DATA_ENTRY_CLERK'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date of the appointment.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_APPOINTMENT', 'COLUMN', N'DATE_APPOINTMENT_MADE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The identifier of the hospital location.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_APPOINTMENT', 'COLUMN', N'HOSPITAL_LOCATION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The telephone number of the hospital location.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_APPOINTMENT', 'COLUMN', N'HOSPITAL_LOCATION_TELEPHONE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The identifier of the table.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_APPOINTMENT', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Foreign key to PATIENT rable.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_APPOINTMENT', 'COLUMN', N'PATIENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Patient appointment''s status.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_APPOINTMENT', 'COLUMN', N'STATUS'
GO