-- Columns

CREATE TABLE [dbo].[PATIENT_MOVEMENT]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[DATETIME] [datetime] NOT NULL,
[ENTERED_ON_DATETIME] [datetime] NOT NULL,
[ENTERED_BY_ID] [int] NULL,
[TRANSACTION_ID] [int] NULL,
[MAS_MOVEMENT_TRANS_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[PATIENT_ID] [int] NOT NULL,
[TYPE_OF_MOVEMENT_ID] [int] NOT NULL,
[FAC_MOVE_TYPE_NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[WARD_LOCATION_ID] [int] NOT NULL,
[ROOM_BED_ID] [int] NOT NULL,
[ADMISSION_CHECK_IN_MOVEMENT_ID] [int] NULL,
[RELATED_PHYSICAL_MOVEMENT_ID] [int] NULL,
[WARD_AT_DISCHARGE] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NULL,
[TRANSACTION_] [nvarchar] (150) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL,
[INTERNAL_UID] [uniqueidentifier] NULL,
)
GO
-- Triggers


CREATE TRIGGER [dbo].[PATIENT_MOVEMENT_tgg_INSERT_update]
   ON  [dbo].[PATIENT_MOVEMENT]
   AFTER insert,update
AS 
BEGIN	

	INSERT INTO [dbo].[WORKFLOW_LOG] ( PATIENT_MOVEMENT_ID )

        SELECT IEN
          FROM inserted;
END
GO
-- Constraints and Indexes

ALTER TABLE [dbo].[PATIENT_MOVEMENT] ADD CONSTRAINT [PK_PATIENT_MOVEMENT] PRIMARY KEY CLUSTERED  ([IEN])
GO
-- Foreign Keys

ALTER TABLE [dbo].[PATIENT_MOVEMENT] ADD CONSTRAINT [FK_PATIENT_MOVEMENT_PATIENT_MOVEMENT1] FOREIGN KEY ([ADMISSION_CHECK_IN_MOVEMENT_ID]) REFERENCES [dbo].[PATIENT_MOVEMENT] ([IEN])
GO
ALTER TABLE [dbo].[PATIENT_MOVEMENT] ADD CONSTRAINT [FK_PATIENT_MOVEMENT_NEW_PERSON] FOREIGN KEY ([ENTERED_BY_ID]) REFERENCES [dbo].[NEW_PERSON] ([IEN])
GO
ALTER TABLE [dbo].[PATIENT_MOVEMENT] ADD CONSTRAINT [FK_PATIENT_MOVEMENT_PATIENT] FOREIGN KEY ([PATIENT_ID]) REFERENCES [dbo].[PATIENT] ([IEN])
GO
ALTER TABLE [dbo].[PATIENT_MOVEMENT] ADD CONSTRAINT [FK_PATIENT_MOVEMENT_PATIENT_MOVEMENT] FOREIGN KEY ([RELATED_PHYSICAL_MOVEMENT_ID]) REFERENCES [dbo].[PATIENT_MOVEMENT] ([IEN])
GO
ALTER TABLE [dbo].[PATIENT_MOVEMENT] ADD CONSTRAINT [FK_PATIENT_MOVEMENT_ROOM_BED] FOREIGN KEY ([ROOM_BED_ID]) REFERENCES [dbo].[ROOM_BED] ([IEN])
GO
ALTER TABLE [dbo].[PATIENT_MOVEMENT] ADD CONSTRAINT [FK_PATIENT_MOVEMENT_TYPE_OF_MOVEMENT] FOREIGN KEY ([TYPE_OF_MOVEMENT_ID]) REFERENCES [dbo].[TYPE_OF_MOVEMENT] ([IEN])
GO
ALTER TABLE [dbo].[PATIENT_MOVEMENT] ADD CONSTRAINT [FK_PATIENT_MOVEMENT_WARD_LOCATION] FOREIGN KEY ([WARD_LOCATION_ID]) REFERENCES [dbo].[WARD_LOCATION] ([IEN])
GO
-- Extended Properties

EXEC sp_addextendedproperty N'MS_Description', N'Table that contains data about patient movement act.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the admission check in.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'ADMISSION_CHECK_IN_MOVEMENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time of the act.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'DATETIME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The person who created the patient movement act.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'ENTERED_BY_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The date and time when the act was created.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'ENTERED_ON_DATETIME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Name of the facility movement type.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'FAC_MOVE_TYPE_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Column that contains unique identifiers for patient movements.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Name of the movement transaction.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'MAS_MOVEMENT_TRANS_NAME'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Patient''s id.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'PATIENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the physical movement.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'RELATED_PHYSICAL_MOVEMENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Bed''s id where the patient is moved.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'ROOM_BED_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the transaction.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'TRANSACTION_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the movement type.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'TYPE_OF_MOVEMENT_ID'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the ward when patients is discharged.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'WARD_AT_DISCHARGE'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Id of the ward''s location from WARD_LOCATION table.', 'SCHEMA', N'dbo', 'TABLE', N'PATIENT_MOVEMENT', 'COLUMN', N'WARD_LOCATION_ID'
GO