CREATE TABLE [dbo].[SPECIALTY]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[SPECIALTY_tgg_delete]
   ON  dbo.SPECIALTY
   AFTER delete
AS 
BEGIN	
	INSERT INTO [dbo].[SPECIALTY_LOG]
           ([ACTION],[IEN],[NAME])
        SELECT 'D',[IEN],[NAME]
        FROM deleted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[SPECIALTY_tgg_insert]
   ON  dbo.SPECIALTY
   AFTER insert
AS 
BEGIN	
	INSERT INTO [dbo].[SPECIALTY_LOG]
           ([ACTION],[IEN],[NAME])
        SELECT 'I',[IEN],[NAME]
        FROM inserted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[SPECIALTY_tgg_update]
   ON  dbo.SPECIALTY
   AFTER update
AS 
BEGIN	
	INSERT INTO [dbo].[SPECIALTY_LOG]
           ([ACTION],[IEN],[NAME])
        SELECT 'U',[IEN],[NAME]
        FROM inserted;
END
GO
ALTER TABLE [dbo].[SPECIALTY] ADD CONSTRAINT [PK_SPECIALTY] PRIMARY KEY CLUSTERED  ([IEN]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'The table contains the list of specialties.', 'SCHEMA', N'dbo', 'TABLE', N'SPECIALTY', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'Specialty''s id.', 'SCHEMA', N'dbo', 'TABLE', N'SPECIALTY', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'Specialty''s name.', 'SCHEMA', N'dbo', 'TABLE', N'SPECIALTY', 'COLUMN', N'NAME'
GO
