CREATE TABLE [dbo].[FAC_TREAT_SPECIALTY]
(
[IEN] [int] NOT NULL IDENTITY(1, 1),
[NAME] [nvarchar] (250) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL
) ON [PRIMARY]
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[FAC_TREAT_SPECIALTY_tgg_delete]
   ON  dbo.FAC_TREAT_SPECIALTY
   AFTER delete
AS 
BEGIN	
	INSERT INTO [dbo].[FAC_TREAT_SPECIALTY_LOG]
           ([ACTION],[IEN],[NAME])
        SELECT 'D',[IEN],[NAME]
        FROM deleted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[FAC_TREAT_SPECIALTY_tgg_insert]
   ON  dbo.FAC_TREAT_SPECIALTY
   AFTER insert
AS 
BEGIN	
	INSERT INTO [dbo].[FAC_TREAT_SPECIALTY_LOG]
           ([ACTION],[IEN],[NAME])
        SELECT 'I',[IEN],[NAME]
        FROM inserted;
END
GO
SET QUOTED_IDENTIFIER ON
GO
SET ANSI_NULLS ON
GO
CREATE TRIGGER [dbo].[FAC_TREAT_SPECIALTY_tgg_update]
   ON  dbo.FAC_TREAT_SPECIALTY
   AFTER update
AS 
BEGIN	
	INSERT INTO [dbo].[FAC_TREAT_SPECIALTY_LOG]
           ([ACTION],[IEN],[NAME])
        SELECT 'U',[IEN],[NAME]
        FROM inserted;
END
GO

ALTER TABLE [dbo].[FAC_TREAT_SPECIALTY] ADD CONSTRAINT [PK_FAC_TREAT_SPECIALTY] PRIMARY KEY CLUSTERED  ([IEN]) ON [PRIMARY]
GO
EXEC sp_addextendedproperty N'MS_Description', N'Table that contains the facility treatment specialties.', 'SCHEMA', N'dbo', 'TABLE', N'FAC_TREAT_SPECIALTY', NULL, NULL
GO
EXEC sp_addextendedproperty N'MS_Description', N'The identifier of the specialty.', 'SCHEMA', N'dbo', 'TABLE', N'FAC_TREAT_SPECIALTY', 'COLUMN', N'IEN'
GO
EXEC sp_addextendedproperty N'MS_Description', N'The name of the specialty.', 'SCHEMA', N'dbo', 'TABLE', N'FAC_TREAT_SPECIALTY', 'COLUMN', N'NAME'
GO
